/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.time.Duration;
import java.util.Optional;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Cache;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Caffeine;
import shadow.palantir.driver.com.google.common.base.Supplier;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.ClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.ImmutableLoggingRateLimiterKey;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.org.immutables.value.Value;

final class DeprecationWarningChannel
implements EndpointChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(DeprecationWarningChannel.class);
    private static final Cache<LoggingRateLimiterKey, Object> loggingRateLimiter = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();
    private static final Object SENTINEL = new Object();
    private final EndpointChannel delegate;
    private final ClientMetrics metrics;
    private final FutureCallback<Response> callback;

    private DeprecationWarningChannel(EndpointChannel delegate, TaggedMetricRegistry metrics, Endpoint endpoint, String channelName) {
        this.delegate = delegate;
        this.metrics = ClientMetrics.of(metrics);
        this.callback = this.createCallback(channelName, endpoint);
    }

    static EndpointChannel create(Config cf, EndpointChannel delegate, Endpoint endpoint) {
        TaggedMetricRegistry metrics = cf.clientConf().taggedMetricRegistry();
        return new DeprecationWarningChannel(delegate, metrics, endpoint, cf.channelName());
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        ListenableFuture<Response> future = this.delegate.execute(request);
        DialogueFutures.addDirectCallback(future, this.callback);
        return future;
    }

    private FutureCallback<Response> createCallback(String channelName, Endpoint endpoint) {
        Supplier meterSupplier = Suppliers.memoize(() -> this.metrics.deprecations(endpoint.serviceName()));
        return DialogueFutures.onSuccess(response -> {
            if (response == null) {
                return;
            }
            Optional<String> maybeHeader = response.getFirstHeader("deprecation");
            if (maybeHeader.isEmpty()) {
                return;
            }
            ((Meter)meterSupplier.get()).mark();
            if (log.isWarnEnabled() && this.tryAcquire(channelName, endpoint)) {
                log.warn("Using a deprecated endpoint when connecting to service", SafeArg.of("channelName", channelName), SafeArg.of("serviceName", endpoint.serviceName()), SafeArg.of("endpointHttpMethod", endpoint.httpMethod()), SafeArg.of("endpointName", endpoint.endpointName()), SafeArg.of("endpointClientVersion", endpoint.version()), SafeArg.of("server", response.getFirstHeader("server").orElse("no server header provided")));
            }
        });
    }

    private boolean tryAcquire(String channelName, Endpoint endpoint) {
        LoggingRateLimiterKey key = LoggingRateLimiterKey.of(channelName, endpoint.serviceName(), endpoint.endpointName());
        if (loggingRateLimiter.getIfPresent(key) == null) {
            loggingRateLimiter.put(key, SENTINEL);
            return true;
        }
        return false;
    }

    public String toString() {
        return "DeprecationWarningChannel{" + this.delegate + "}";
    }

    @Value.Immutable
    static interface LoggingRateLimiterKey {
        @Value.Parameter
        public String channelName();

        @Value.Parameter
        public String serviceName();

        @Value.Parameter
        public String endpointName();

        public static LoggingRateLimiterKey of(String channel, String service, String endpoint) {
            return ImmutableLoggingRateLimiterKey.of(channel, service, endpoint);
        }
    }
}

