/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.ClientConfiguration;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.ChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.core.ChannelToEndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.ChannelToLimitedChannelAdapter;
import shadow.palantir.driver.com.palantir.dialogue.core.ConcurrencyLimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.ContentDecodingChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.ContentEncodingChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.DeprecationWarningChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueTracing;
import shadow.palantir.driver.com.palantir.dialogue.core.EndpointChannelAdapter;
import shadow.palantir.driver.com.palantir.dialogue.core.HostMetricsChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.ImmutableConfig;
import shadow.palantir.driver.com.palantir.dialogue.core.InterruptionChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.NeverThrowEndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.NodeSelectionStrategyChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.QueueOverrideChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.QueuedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.RangeAcceptsIdentityEncodingChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.RequestBodyValidationChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.RetryOtherValidatingChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.RetryingChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.StickyEndpointChannels2;
import shadow.palantir.driver.com.palantir.dialogue.core.StickyValidationChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.SupplierChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.TargetUri;
import shadow.palantir.driver.com.palantir.dialogue.core.TimingEndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.TraceEnrichingChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.TracedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.UserAgentEndpointChannel;
import shadow.palantir.driver.com.palantir.refreshable.Refreshable;

public final class DialogueChannel
implements Channel,
EndpointChannelFactory {
    private static final SafeLogger log = SafeLoggerFactory.get(DialogueChannel.class);
    private final EndpointChannelFactory delegate;
    private final Config cf;
    private final Supplier<Channel> stickyChannelSupplier;

    private DialogueChannel(Config cf, EndpointChannelFactory delegate, Supplier<Channel> stickyChannelSupplier) {
        this.cf = cf;
        this.delegate = delegate;
        this.stickyChannelSupplier = stickyChannelSupplier;
    }

    @Override
    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        return this.delegate.endpoint(endpoint).execute(request);
    }

    @Override
    public EndpointChannel endpoint(Endpoint endpoint) {
        return this.delegate.endpoint(endpoint);
    }

    public Supplier<Channel> stickyChannels() {
        return this.stickyChannelSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "DialogueChannel@" + Integer.toHexString(System.identityHashCode(this)) + "{channelName=" + this.cf.channelName() + ", delegate=" + this.delegate + "}";
    }

    public static final class Builder {
        private final ImmutableConfig.Builder builder = ImmutableConfig.builder();

        private Builder() {
        }

        public Builder channelName(@Safe String channelName) {
            this.builder.channelName(channelName);
            return this;
        }

        public Builder clientConfiguration(ClientConfiguration value) {
            this.builder.rawConfig(value);
            return this;
        }

        @Deprecated
        public Builder uris(List<TargetUri> value) {
            return this.uris(Refreshable.only(value));
        }

        public Builder uris(Refreshable<List<TargetUri>> value) {
            this.builder.uris(value);
            return this;
        }

        @Deprecated
        public Builder channelFactory(ChannelFactory value) {
            return this.factory(DialogueChannelFactory.from(value));
        }

        public Builder factory(DialogueChannelFactory value) {
            this.builder.channelFactory(value);
            return this;
        }

        public Builder overrideHostIndex(OptionalInt maybeUriIndex) {
            this.builder.overrideSingleHostIndex(maybeUriIndex);
            return this;
        }

        @VisibleForTesting
        Builder random(Random value) {
            this.builder.random(value);
            return this;
        }

        @VisibleForTesting
        Builder scheduler(ScheduledExecutorService value) {
            this.builder.scheduler(value);
            return this;
        }

        @VisibleForTesting
        Builder maxQueueSize(int value) {
            this.builder.maxQueueSize(value);
            return this;
        }

        @VisibleForTesting
        Builder ticker(Ticker value) {
            this.builder.ticker(value);
            return this;
        }

        @CheckReturnValue
        public DialogueChannel build() {
            ImmutableConfig cf = this.builder.build();
            DialogueClientMetrics clientMetrics = DialogueClientMetrics.of(cf.clientConf().taggedMetricRegistry());
            Meter reloadMeter = clientMetrics.reload().clientName(cf.channelName()).clientType("dialogue-channel-non-reloading").build();
            SupplierChannel nodeSelectionChannel = new SupplierChannel(cf.uris().map(targetUris -> {
                reloadMeter.mark();
                log.info("Reloaded channel '{}' targets. (uris: {}, numUris: {}, targets: {}, numTargets: {})", SafeArg.of("channel", cf.channelName()), UnsafeArg.of("uris", cf.clientConf().uris()), SafeArg.of("numUris", cf.clientConf().uris().size()), UnsafeArg.of("targets", targetUris), SafeArg.of("numTargets", targetUris.size()));
                ImmutableList<LimitedChannel> targetChannels = Builder.createHostChannels(cf, targetUris);
                return NodeSelectionStrategyChannel.create(cf, targetChannels);
            }));
            StickyValidationChannel stickyValidationChannel = new StickyValidationChannel(nodeSelectionChannel);
            QueuedChannel multiHostQueuedChannel = QueuedChannel.create(cf, stickyValidationChannel);
            EndpointChannelFactory channelFactory = Builder.createEndpointChannelFactory(multiHostQueuedChannel, cf);
            Supplier<Channel> stickyChannelSupplier = StickyEndpointChannels2.create(cf, stickyValidationChannel, channelFactory);
            Meter createMeter = clientMetrics.create().clientName(cf.channelName()).clientType("dialogue-channel-non-reloading").build();
            createMeter.mark();
            return new DialogueChannel(cf, channelFactory, stickyChannelSupplier);
        }

        private static ImmutableList<LimitedChannel> createHostChannels(Config cf, List<TargetUri> targetUris) {
            ImmutableList.Builder perUriChannels = ImmutableList.builder();
            for (int uriIndex = 0; uriIndex < targetUris.size(); ++uriIndex) {
                int uriIndexForInstrumentation = cf.overrideSingleHostIndex().orElse(uriIndex);
                TargetUri targetUri = targetUris.get(uriIndex);
                Channel channel = cf.channelFactory().create(DialogueChannelFactory.ChannelArgs.builder().uri(targetUri.uri()).uriIndexForInstrumentation(uriIndexForInstrumentation).resolvedAddress(targetUri.resolvedAddress()).build());
                channel = RetryOtherValidatingChannel.create(cf, channel);
                channel = HostMetricsChannel.create(cf, channel, targetUri.uri());
                TraceEnrichingChannel tracingChannel = new TraceEnrichingChannel(channel, DialogueTracing.tracingTags(cf, uriIndexForInstrumentation));
                channel = cf.isConcurrencyLimitingEnabled() ? new ChannelToEndpointChannel(endpoint -> {
                    if (endpoint.tags().contains("dialogue-disable-endpoint-concurrency-limiting")) {
                        return tracingChannel;
                    }
                    LimitedChannel limited = ConcurrencyLimitedChannel.createForEndpoint(tracingChannel, cf.channelName(), uriIndexForInstrumentation, endpoint);
                    return QueuedChannel.create(cf, endpoint, limited);
                }) : tracingChannel;
                LimitedChannel limitedChannel = cf.isConcurrencyLimitingEnabled() ? ConcurrencyLimitedChannel.createForHost(cf, channel, uriIndexForInstrumentation) : new ChannelToLimitedChannelAdapter(channel);
                perUriChannels.add(limitedChannel);
            }
            return perUriChannels.build();
        }

        private static EndpointChannelFactory createEndpointChannelFactory(Channel multiHostQueuedChannel, Config cf) {
            QueueOverrideChannel queuedChannel = new QueueOverrideChannel(multiHostQueuedChannel);
            return endpoint -> {
                EndpointChannelAdapter endpointChannel = new EndpointChannelAdapter(endpoint, queuedChannel);
                EndpointChannel channel = cf.clientConf().userAgent().map(userAgent -> UserAgentEndpointChannel.create(endpointChannel, endpoint, userAgent)).orElse(endpointChannel);
                channel = RetryingChannel.create(cf, channel, endpoint);
                channel = DeprecationWarningChannel.create(cf, channel, endpoint);
                channel = ContentDecodingChannel.create(cf, channel, endpoint);
                channel = new RangeAcceptsIdentityEncodingChannel(channel);
                channel = ContentEncodingChannel.of(channel, endpoint);
                channel = TracedChannel.create(cf, channel, endpoint);
                if (ChannelToEndpointChannel.isConstant(endpoint)) {
                    channel = TimingEndpointChannel.create(cf, channel, endpoint);
                }
                channel = new RequestBodyValidationChannel(channel);
                channel = new InterruptionChannel(channel);
                return new NeverThrowEndpointChannel(channel);
            };
        }

        @CheckReturnValue
        public Channel buildNonLiveReloading() {
            return this.build();
        }
    }
}

