/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Gauge;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueConcurrencylimiterMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "4.0.0";
    private final TaggedMetricRegistry registry;

    private DialogueConcurrencylimiterMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueConcurrencylimiterMetrics of(TaggedMetricRegistry registry) {
        return new DialogueConcurrencylimiterMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    MaxBuilderChannelNameStage max() {
        return new MaxBuilder();
    }

    @CheckReturnValue
    InFlightBuilderChannelNameStage inFlight() {
        return new InFlightBuilder();
    }

    public String toString() {
        return "DialogueConcurrencylimiterMetrics{registry=" + this.registry + "}";
    }

    private final class InFlightBuilder
    implements InFlightBuilderChannelNameStage,
    InFlightBuilderHostIndexStage,
    InFlightBuildStage {
        private String channelName;
        private String hostIndex;

        private InFlightBuilder() {
        }

        @Override
        public InFlightBuilder channelName(@Safe String channelName) {
            Preconditions.checkState(this.channelName == null, "channel-name is already set");
            this.channelName = Preconditions.checkNotNull(channelName, "channel-name is required");
            return this;
        }

        @Override
        public InFlightBuilder hostIndex(@Safe String hostIndex) {
            Preconditions.checkState(this.hostIndex == null, "hostIndex is already set");
            this.hostIndex = Preconditions.checkNotNull(hostIndex, "hostIndex is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            DialogueConcurrencylimiterMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.concurrencylimiter.in-flight").putSafeTags("channel-name", this.channelName).putSafeTags("hostIndex", this.hostIndex).putSafeTags("libraryName", DialogueConcurrencylimiterMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueConcurrencylimiterMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface InFlightBuilderHostIndexStage {
        @CheckReturnValue
        public InFlightBuildStage hostIndex(@Safe String var1);
    }

    static interface InFlightBuilderChannelNameStage {
        @CheckReturnValue
        public InFlightBuilderHostIndexStage channelName(@Safe String var1);
    }

    static interface InFlightBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    private final class MaxBuilder
    implements MaxBuilderChannelNameStage,
    MaxBuilderHostIndexStage,
    MaxBuildStage {
        private String channelName;
        private String hostIndex;

        private MaxBuilder() {
        }

        @Override
        public MaxBuilder channelName(@Safe String channelName) {
            Preconditions.checkState(this.channelName == null, "channel-name is already set");
            this.channelName = Preconditions.checkNotNull(channelName, "channel-name is required");
            return this;
        }

        @Override
        public MaxBuilder hostIndex(@Safe String hostIndex) {
            Preconditions.checkState(this.hostIndex == null, "hostIndex is already set");
            this.hostIndex = Preconditions.checkNotNull(hostIndex, "hostIndex is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            DialogueConcurrencylimiterMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.concurrencylimiter.max").putSafeTags("channel-name", this.channelName).putSafeTags("hostIndex", this.hostIndex).putSafeTags("libraryName", DialogueConcurrencylimiterMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueConcurrencylimiterMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface MaxBuilderHostIndexStage {
        @CheckReturnValue
        public MaxBuildStage hostIndex(@Safe String var1);
    }

    static interface MaxBuilderChannelNameStage {
        @CheckReturnValue
        public MaxBuilderHostIndexStage channelName(@Safe String var1);
    }

    static interface MaxBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

