/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.List;
import shadow.palantir.driver.com.google.common.base.Splitter;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.Lists;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.NodeSelectionStrategy;

enum DialogueNodeSelectionStrategy {
    PIN_UNTIL_ERROR,
    PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE,
    BALANCED,
    UNKNOWN;

    private static final SafeLogger log;
    private static final Splitter SPLITTER;

    static List<DialogueNodeSelectionStrategy> fromHeader(String header) {
        return ImmutableList.copyOf(Lists.transform(SPLITTER.splitToList(header), DialogueNodeSelectionStrategy::safeValueOf));
    }

    private static DialogueNodeSelectionStrategy safeValueOf(String string) {
        if ("PIN_UNTIL_ERROR".equalsIgnoreCase(string)) {
            return PIN_UNTIL_ERROR;
        }
        if ("PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE".equalsIgnoreCase(string)) {
            return PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE;
        }
        if ("BALANCED".equalsIgnoreCase(string)) {
            return BALANCED;
        }
        log.info("Received unknown selection strategy {}", SafeArg.of("strategy", string));
        return UNKNOWN;
    }

    static DialogueNodeSelectionStrategy of(NodeSelectionStrategy strategy) {
        switch (strategy) {
            case PIN_UNTIL_ERROR: {
                return PIN_UNTIL_ERROR;
            }
            case PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE: {
                return PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE;
            }
            case ROUND_ROBIN: {
                return BALANCED;
            }
        }
        throw new SafeIllegalStateException("Unknown node selection strategy", SafeArg.of("strategy", strategy));
    }

    static {
        log = SafeLoggerFactory.get(DialogueNodeSelectionStrategy.class);
        SPLITTER = Splitter.on(",").trimResults().omitEmptyStrings();
    }
}

