/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueNodeselectionMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "4.0.0";
    private final TaggedMetricRegistry registry;

    private DialogueNodeselectionMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueNodeselectionMetrics of(TaggedMetricRegistry registry) {
        return new DialogueNodeselectionMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    StrategyBuilderChannelNameStage strategy() {
        return new StrategyBuilder();
    }

    public String toString() {
        return "DialogueNodeselectionMetrics{registry=" + this.registry + "}";
    }

    private final class StrategyBuilder
    implements StrategyBuilderChannelNameStage,
    StrategyBuilderStrategyStage,
    StrategyBuildStage {
        private String channelName;
        private String strategy;

        private StrategyBuilder() {
        }

        @Override
        public StrategyBuilder channelName(@Safe String channelName) {
            Preconditions.checkState(this.channelName == null, "channel-name is already set");
            this.channelName = Preconditions.checkNotNull(channelName, "channel-name is required");
            return this;
        }

        @Override
        public StrategyBuilder strategy(@Safe String strategy) {
            Preconditions.checkState(this.strategy == null, "strategy is already set");
            this.strategy = Preconditions.checkNotNull(strategy, "strategy is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueNodeselectionMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.nodeselection.strategy").putSafeTags("channel-name", this.channelName).putSafeTags("strategy", this.strategy).putSafeTags("libraryName", DialogueNodeselectionMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueNodeselectionMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface StrategyBuilderStrategyStage {
        @CheckReturnValue
        public StrategyBuildStage strategy(@Safe String var1);
    }

    static interface StrategyBuilderChannelNameStage {
        @CheckReturnValue
        public StrategyBuilderStrategyStage channelName(@Safe String var1);
    }

    static interface StrategyBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

