/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialoguePinuntilerrorMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "4.0.0";
    private final TaggedMetricRegistry registry;

    private DialoguePinuntilerrorMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialoguePinuntilerrorMetrics of(TaggedMetricRegistry registry) {
        return new DialoguePinuntilerrorMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    SuccessBuilderChannelNameStage success() {
        return new SuccessBuilder();
    }

    @CheckReturnValue
    NextNodeBuilderChannelNameStage nextNode() {
        return new NextNodeBuilder();
    }

    @CheckReturnValue
    Meter reshuffle(@Safe String channelName) {
        return this.registry.meter(DialoguePinuntilerrorMetrics.reshuffleMetricName(channelName));
    }

    static MetricName reshuffleMetricName(@Safe String channelName) {
        return MetricName.builder().safeName("dialogue.pinuntilerror.reshuffle").putSafeTags("channel-name", channelName).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    public String toString() {
        return "DialoguePinuntilerrorMetrics{registry=" + this.registry + "}";
    }

    private final class NextNodeBuilder
    implements NextNodeBuilderChannelNameStage,
    NextNodeBuilderReasonStage,
    NextNodeBuildStage {
        private String channelName;
        private String reason;

        private NextNodeBuilder() {
        }

        @Override
        public NextNodeBuilder channelName(@Safe String channelName) {
            Preconditions.checkState(this.channelName == null, "channel-name is already set");
            this.channelName = Preconditions.checkNotNull(channelName, "channel-name is required");
            return this;
        }

        @Override
        public NextNodeBuilder reason(@Safe String reason) {
            Preconditions.checkState(this.reason == null, "reason is already set");
            this.reason = Preconditions.checkNotNull(reason, "reason is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialoguePinuntilerrorMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.pinuntilerror.nextNode").putSafeTags("channel-name", this.channelName).putSafeTags("reason", this.reason).putSafeTags("libraryName", DialoguePinuntilerrorMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialoguePinuntilerrorMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface NextNodeBuilderReasonStage {
        @CheckReturnValue
        public NextNodeBuildStage reason(@Safe String var1);
    }

    static interface NextNodeBuilderChannelNameStage {
        @CheckReturnValue
        public NextNodeBuilderReasonStage channelName(@Safe String var1);
    }

    static interface NextNodeBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    private final class SuccessBuilder
    implements SuccessBuilderChannelNameStage,
    SuccessBuilderHostIndexStage,
    SuccessBuildStage {
        private String channelName;
        private String hostIndex;

        private SuccessBuilder() {
        }

        @Override
        public SuccessBuilder channelName(@Safe String channelName) {
            Preconditions.checkState(this.channelName == null, "channel-name is already set");
            this.channelName = Preconditions.checkNotNull(channelName, "channel-name is required");
            return this;
        }

        @Override
        public SuccessBuilder hostIndex(@Safe String hostIndex) {
            Preconditions.checkState(this.hostIndex == null, "hostIndex is already set");
            this.hostIndex = Preconditions.checkNotNull(hostIndex, "hostIndex is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialoguePinuntilerrorMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.pinuntilerror.success").putSafeTags("channel-name", this.channelName).putSafeTags("hostIndex", this.hostIndex).putSafeTags("libraryName", DialoguePinuntilerrorMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialoguePinuntilerrorMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface SuccessBuilderHostIndexStage {
        @CheckReturnValue
        public SuccessBuildStage hostIndex(@Safe String var1);
    }

    static interface SuccessBuilderChannelNameStage {
        @CheckReturnValue
        public SuccessBuilderHostIndexStage channelName(@Safe String var1);
    }

    static interface SuccessBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

