/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueRoundrobinMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "4.0.0";
    private final TaggedMetricRegistry registry;

    private DialogueRoundrobinMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueRoundrobinMetrics of(TaggedMetricRegistry registry) {
        return new DialogueRoundrobinMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    SuccessBuilderChannelNameStage success() {
        return new SuccessBuilder();
    }

    public String toString() {
        return "DialogueRoundrobinMetrics{registry=" + this.registry + "}";
    }

    private final class SuccessBuilder
    implements SuccessBuilderChannelNameStage,
    SuccessBuilderHostIndexStage,
    SuccessBuildStage {
        private String channelName;
        private String hostIndex;

        private SuccessBuilder() {
        }

        @Override
        public SuccessBuilder channelName(@Safe String channelName) {
            Preconditions.checkState(this.channelName == null, "channel-name is already set");
            this.channelName = Preconditions.checkNotNull(channelName, "channel-name is required");
            return this;
        }

        @Override
        public SuccessBuilder hostIndex(@Safe String hostIndex) {
            Preconditions.checkState(this.hostIndex == null, "hostIndex is already set");
            this.hostIndex = Preconditions.checkNotNull(hostIndex, "hostIndex is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueRoundrobinMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.roundrobin.success").putSafeTags("channel-name", this.channelName).putSafeTags("hostIndex", this.hostIndex).putSafeTags("libraryName", DialogueRoundrobinMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueRoundrobinMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface SuccessBuilderHostIndexStage {
        @CheckReturnValue
        public SuccessBuildStage hostIndex(@Safe String var1);
    }

    static interface SuccessBuilderChannelNameStage {
        @CheckReturnValue
        public SuccessBuilderHostIndexStage channelName(@Safe String var1);
    }

    static interface SuccessBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

