/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.MeshMode;
import shadow.palantir.driver.com.palantir.tracing.TagTranslator;

final class DialogueTracing {
    static ImmutableMap<String, String> tracingTags(Endpoint endpoint) {
        return ImmutableMap.of("endpointService", endpoint.serviceName(), "endpointName", endpoint.endpointName(), "http.method", endpoint.httpMethod().toString());
    }

    static ImmutableMap<String, String> tracingTags(Config cf) {
        return ImmutableMap.of("channel", cf.channelName(), "mesh", Boolean.toString(cf.mesh() == MeshMode.USE_EXTERNAL_MESH));
    }

    static ImmutableMap<String, String> tracingTags(Config cf, int hostIndex) {
        return ImmutableMap.of("channel", cf.channelName(), "mesh", Boolean.toString(cf.mesh() == MeshMode.USE_EXTERNAL_MESH), "hostIndex", Integer.toString(hostIndex));
    }

    static TagTranslator<Response> responseTranslator(final ImmutableMap<String, String> tags) {
        return new TagTranslator<Response>(){

            @Override
            public <T> void translate(TagTranslator.TagAdapter<T> sink, T target, Response response) {
                sink.tag(target, tags);
                int status = response.code();
                sink.tag(target, "outcome", status / 100 == 2 ? "success" : "failure");
                sink.tag(target, "http.status_code", Integer.toString(status));
            }
        };
    }

    static TagTranslator<Throwable> failureTranslator(final ImmutableMap<String, String> tags) {
        return new TagTranslator<Throwable>(){

            @Override
            public <T> void translate(TagTranslator.TagAdapter<T> sink, T target, Throwable response) {
                sink.tag(target, tags);
                sink.tag(target, "outcome", "failure");
                sink.tag(target, "cause", response.getClass().getSimpleName());
            }
        };
    }

    private DialogueTracing() {
    }
}

