/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.HostEventsSink;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;

final class HostMetricsChannel
implements Channel {
    private final Channel delegate;
    private final Ticker clock;
    private final HostEventsSink.HostEventCallback hostEventCallback;

    private HostMetricsChannel(Channel delegate, HostEventsSink hostMetrics, Ticker ticker, String serviceName, String host, int port) {
        this.delegate = Preconditions.checkNotNull(delegate, "Channel is required");
        this.clock = ticker;
        this.hostEventCallback = Preconditions.checkNotNull(hostMetrics, "HostEventsSink is required").callback(Preconditions.checkNotNull(serviceName, "Service is required"), Preconditions.checkNotNull(host, "Host is required"), port);
    }

    static Channel create(Config cf, Channel channel, String uri) {
        Optional<HostEventsSink> hostEventsSink = cf.clientConf().hostEventsSink();
        if (!hostEventsSink.isPresent()) {
            return channel;
        }
        if (hostEventsSink.get().getClass().getSimpleName().equals("NoOpHostEventsSink")) {
            return channel;
        }
        try {
            URL parsed = new URL(uri);
            String host = parsed.getHost();
            int port = parsed.getPort() != -1 ? parsed.getPort() : parsed.getDefaultPort();
            return new HostMetricsChannel(channel, hostEventsSink.get(), cf.ticker(), cf.channelName(), host, port);
        }
        catch (MalformedURLException e) {
            throw new SafeIllegalArgumentException("Failed to parse URI", UnsafeArg.of("uri", uri));
        }
    }

    @Override
    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        ListenableFuture<Response> result = this.delegate.execute(endpoint, request);
        DialogueFutures.addDirectCallback(result, new Callback());
        return result;
    }

    public String toString() {
        return "HostMetricsChannel{delegate=" + this.delegate + ", hostEventCallback=" + this.hostEventCallback + "}";
    }

    private final class Callback
    implements FutureCallback<Response> {
        private final long startNanos;

        private Callback() {
            this.startNanos = HostMetricsChannel.this.clock.read();
        }

        @Override
        public void onSuccess(Response result) {
            HostMetricsChannel.this.hostEventCallback.record(result.code(), TimeUnit.NANOSECONDS.toMicros(HostMetricsChannel.this.clock.read() - this.startNanos));
        }

        @Override
        public void onFailure(Throwable throwable) {
            if (throwable instanceof IOException) {
                HostMetricsChannel.this.hostEventCallback.recordIoException();
            }
        }
    }
}

