/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueChannelFactory;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DialogueChannelFactory.ChannelArgs", generator="Immutables")
@Immutable
final class ImmutableChannelArgs
implements DialogueChannelFactory.ChannelArgs {
    private final String uri;
    @Nullable
    private final InetAddress resolvedAddress;
    @Nullable
    private final Integer uriIndexForInstrumentation;

    private ImmutableChannelArgs(String uri, @Nullable InetAddress resolvedAddress, @Nullable Integer uriIndexForInstrumentation) {
        this.uri = uri;
        this.resolvedAddress = resolvedAddress;
        this.uriIndexForInstrumentation = uriIndexForInstrumentation;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public Optional<InetAddress> resolvedAddress() {
        return Optional.ofNullable(this.resolvedAddress);
    }

    @Override
    public OptionalInt uriIndexForInstrumentation() {
        return this.uriIndexForInstrumentation != null ? OptionalInt.of(this.uriIndexForInstrumentation) : OptionalInt.empty();
    }

    public final ImmutableChannelArgs withUri(String value) {
        String newValue = Objects.requireNonNull(value, "uri");
        if (this.uri.equals(newValue)) {
            return this;
        }
        return new ImmutableChannelArgs(newValue, this.resolvedAddress, this.uriIndexForInstrumentation);
    }

    public final ImmutableChannelArgs withResolvedAddress(InetAddress value) {
        InetAddress newValue = Objects.requireNonNull(value, "resolvedAddress");
        if (this.resolvedAddress == newValue) {
            return this;
        }
        return new ImmutableChannelArgs(this.uri, newValue, this.uriIndexForInstrumentation);
    }

    public final ImmutableChannelArgs withResolvedAddress(Optional<? extends InetAddress> optional) {
        InetAddress value = optional.orElse(null);
        if (this.resolvedAddress == value) {
            return this;
        }
        return new ImmutableChannelArgs(this.uri, value, this.uriIndexForInstrumentation);
    }

    public final ImmutableChannelArgs withUriIndexForInstrumentation(int value) {
        Integer newValue = value;
        if (Objects.equals(this.uriIndexForInstrumentation, newValue)) {
            return this;
        }
        return new ImmutableChannelArgs(this.uri, this.resolvedAddress, newValue);
    }

    public final ImmutableChannelArgs withUriIndexForInstrumentation(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.uriIndexForInstrumentation, value)) {
            return this;
        }
        return new ImmutableChannelArgs(this.uri, this.resolvedAddress, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelArgs && this.equalTo(0, (ImmutableChannelArgs)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelArgs another) {
        return this.uri.equals(another.uri) && Objects.equals(this.resolvedAddress, another.resolvedAddress) && Objects.equals(this.uriIndexForInstrumentation, another.uriIndexForInstrumentation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.uri.hashCode();
        h += (h << 5) + Objects.hashCode(this.resolvedAddress);
        h += (h << 5) + Objects.hashCode(this.uriIndexForInstrumentation);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelArgs{");
        builder.append("uri=").append(this.uri);
        if (this.resolvedAddress != null) {
            builder.append(", ");
            builder.append("resolvedAddress=").append(this.resolvedAddress);
        }
        if (this.uriIndexForInstrumentation != null) {
            builder.append(", ");
            builder.append("uriIndexForInstrumentation=").append(this.uriIndexForInstrumentation);
        }
        return builder.append("}").toString();
    }

    public static DialogueChannelFactory.ChannelArgs copyOf(DialogueChannelFactory.ChannelArgs instance) {
        if (instance instanceof ImmutableChannelArgs) {
            return (ImmutableChannelArgs)instance;
        }
        return new DialogueChannelFactory.ChannelArgs.Builder().from(instance).build();
    }

    @Generated(from="DialogueChannelFactory.ChannelArgs", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_URI = 1L;
        private long initBits = 1L;
        @Nullable
        private String uri;
        @Nullable
        private InetAddress resolvedAddress;
        @Nullable
        private Integer uriIndexForInstrumentation;

        public Builder() {
            if (!(this instanceof DialogueChannelFactory.ChannelArgs.Builder)) {
                throw new UnsupportedOperationException("Use: new DialogueChannelFactory.ChannelArgs.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final DialogueChannelFactory.ChannelArgs.Builder from(DialogueChannelFactory.ChannelArgs instance) {
            OptionalInt uriIndexForInstrumentationOptional;
            Objects.requireNonNull(instance, "instance");
            this.uri(instance.uri());
            Optional<InetAddress> resolvedAddressOptional = instance.resolvedAddress();
            if (resolvedAddressOptional.isPresent()) {
                this.resolvedAddress(resolvedAddressOptional);
            }
            if ((uriIndexForInstrumentationOptional = instance.uriIndexForInstrumentation()).isPresent()) {
                this.uriIndexForInstrumentation(uriIndexForInstrumentationOptional);
            }
            return (DialogueChannelFactory.ChannelArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DialogueChannelFactory.ChannelArgs.Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (DialogueChannelFactory.ChannelArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DialogueChannelFactory.ChannelArgs.Builder resolvedAddress(InetAddress resolvedAddress) {
            this.resolvedAddress = Objects.requireNonNull(resolvedAddress, "resolvedAddress");
            return (DialogueChannelFactory.ChannelArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DialogueChannelFactory.ChannelArgs.Builder resolvedAddress(Optional<? extends InetAddress> resolvedAddress) {
            this.resolvedAddress = resolvedAddress.orElse(null);
            return (DialogueChannelFactory.ChannelArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DialogueChannelFactory.ChannelArgs.Builder uriIndexForInstrumentation(int uriIndexForInstrumentation) {
            this.uriIndexForInstrumentation = uriIndexForInstrumentation;
            return (DialogueChannelFactory.ChannelArgs.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DialogueChannelFactory.ChannelArgs.Builder uriIndexForInstrumentation(OptionalInt uriIndexForInstrumentation) {
            this.uriIndexForInstrumentation = uriIndexForInstrumentation.isPresent() ? Integer.valueOf(uriIndexForInstrumentation.getAsInt()) : null;
            return (DialogueChannelFactory.ChannelArgs.Builder)this;
        }

        public DialogueChannelFactory.ChannelArgs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelArgs(this.uri, this.resolvedAddress, this.uriIndexForInstrumentation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("uri");
            }
            return "Cannot build ChannelArgs, some of required attributes are not set " + attributes;
        }
    }
}

