/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.primitives.Booleans;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.ClientConfiguration;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.core.MeshMode;
import shadow.palantir.driver.com.palantir.dialogue.core.TargetUri;
import shadow.palantir.driver.com.palantir.refreshable.Refreshable;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Config", generator="Immutables")
@Immutable
final class ImmutableConfig
implements Config {
    private final String channelName;
    private final DialogueChannelFactory channelFactory;
    private final ClientConfiguration rawConfig;
    private final transient ClientConfiguration clientConf;
    private final Refreshable<List<TargetUri>> uris;
    private final transient MeshMode mesh;
    private final transient boolean isConcurrencyLimitingEnabled;
    private final Random random;
    private final ScheduledExecutorService scheduler;
    private final Ticker ticker;
    private final int maxQueueSize;
    @Nullable
    private final Integer overrideSingleHostIndex;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableConfig(Builder builder) {
        this.channelName = builder.channelName;
        this.channelFactory = builder.channelFactory;
        this.rawConfig = builder.rawConfig;
        this.overrideSingleHostIndex = builder.overrideSingleHostIndex;
        if (builder.uris != null) {
            this.initShim.uris(builder.uris);
        }
        if (builder.random != null) {
            this.initShim.random(builder.random);
        }
        if (builder.scheduler != null) {
            this.initShim.scheduler(builder.scheduler);
        }
        if (builder.ticker != null) {
            this.initShim.ticker(builder.ticker);
        }
        if (builder.maxQueueSizeIsSet()) {
            this.initShim.maxQueueSize(builder.maxQueueSize);
        }
        this.clientConf = this.initShim.clientConf();
        this.uris = this.initShim.uris();
        this.mesh = this.initShim.mesh();
        this.isConcurrencyLimitingEnabled = this.initShim.isConcurrencyLimitingEnabled();
        this.random = this.initShim.random();
        this.scheduler = this.initShim.scheduler();
        this.ticker = this.initShim.ticker();
        this.maxQueueSize = this.initShim.maxQueueSize();
        this.initShim = null;
    }

    private ImmutableConfig(String channelName, DialogueChannelFactory channelFactory, ClientConfiguration rawConfig, Refreshable<List<TargetUri>> uris, Random random, ScheduledExecutorService scheduler, Ticker ticker, int maxQueueSize, @Nullable Integer overrideSingleHostIndex) {
        this.channelName = channelName;
        this.channelFactory = channelFactory;
        this.rawConfig = rawConfig;
        this.initShim.uris(uris);
        this.initShim.random(random);
        this.initShim.scheduler(scheduler);
        this.initShim.ticker(ticker);
        this.initShim.maxQueueSize(maxQueueSize);
        this.overrideSingleHostIndex = overrideSingleHostIndex;
        this.clientConf = this.initShim.clientConf();
        this.uris = this.initShim.uris();
        this.mesh = this.initShim.mesh();
        this.isConcurrencyLimitingEnabled = this.initShim.isConcurrencyLimitingEnabled();
        this.random = this.initShim.random();
        this.scheduler = this.initShim.scheduler();
        this.ticker = this.initShim.ticker();
        this.maxQueueSize = this.initShim.maxQueueSize();
        this.initShim = null;
    }

    private ClientConfiguration clientConfInitialize() {
        return Config.super.clientConf();
    }

    private Refreshable<List<TargetUri>> urisInitialize() {
        return Config.super.uris();
    }

    private MeshMode meshInitialize() {
        return Config.super.mesh();
    }

    private boolean isConcurrencyLimitingEnabledInitialize() {
        return Config.super.isConcurrencyLimitingEnabled();
    }

    private Random randomInitialize() {
        return Config.super.random();
    }

    private ScheduledExecutorService schedulerInitialize() {
        return Config.super.scheduler();
    }

    private Ticker tickerInitialize() {
        return Config.super.ticker();
    }

    private int maxQueueSizeInitialize() {
        return Config.super.maxQueueSize();
    }

    @Override
    public String channelName() {
        return this.channelName;
    }

    @Override
    public DialogueChannelFactory channelFactory() {
        return this.channelFactory;
    }

    @Override
    public ClientConfiguration rawConfig() {
        return this.rawConfig;
    }

    @Override
    public ClientConfiguration clientConf() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clientConf() : this.clientConf;
    }

    @Override
    public Refreshable<List<TargetUri>> uris() {
        InitShim shim = this.initShim;
        return shim != null ? shim.uris() : this.uris;
    }

    @Override
    public MeshMode mesh() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mesh() : this.mesh;
    }

    @Override
    public boolean isConcurrencyLimitingEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isConcurrencyLimitingEnabled() : this.isConcurrencyLimitingEnabled;
    }

    @Override
    public Random random() {
        InitShim shim = this.initShim;
        return shim != null ? shim.random() : this.random;
    }

    @Override
    public ScheduledExecutorService scheduler() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scheduler() : this.scheduler;
    }

    @Override
    public Ticker ticker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ticker() : this.ticker;
    }

    @Override
    public int maxQueueSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxQueueSize() : this.maxQueueSize;
    }

    @Override
    public OptionalInt overrideSingleHostIndex() {
        return this.overrideSingleHostIndex != null ? OptionalInt.of(this.overrideSingleHostIndex) : OptionalInt.empty();
    }

    public final ImmutableConfig withChannelName(String value) {
        String newValue = Objects.requireNonNull(value, "channelName");
        if (this.channelName.equals(newValue)) {
            return this;
        }
        return ImmutableConfig.validate(new ImmutableConfig(newValue, this.channelFactory, this.rawConfig, this.uris, this.random, this.scheduler, this.ticker, this.maxQueueSize, this.overrideSingleHostIndex));
    }

    public final ImmutableConfig withChannelFactory(DialogueChannelFactory value) {
        if (this.channelFactory == value) {
            return this;
        }
        DialogueChannelFactory newValue = Objects.requireNonNull(value, "channelFactory");
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, newValue, this.rawConfig, this.uris, this.random, this.scheduler, this.ticker, this.maxQueueSize, this.overrideSingleHostIndex));
    }

    public final ImmutableConfig withRawConfig(ClientConfiguration value) {
        if (this.rawConfig == value) {
            return this;
        }
        ClientConfiguration newValue = Objects.requireNonNull(value, "rawConfig");
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, this.channelFactory, newValue, this.uris, this.random, this.scheduler, this.ticker, this.maxQueueSize, this.overrideSingleHostIndex));
    }

    public final ImmutableConfig withUris(Refreshable<List<TargetUri>> value) {
        if (this.uris == value) {
            return this;
        }
        Refreshable<List<TargetUri>> newValue = Objects.requireNonNull(value, "uris");
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, this.channelFactory, this.rawConfig, newValue, this.random, this.scheduler, this.ticker, this.maxQueueSize, this.overrideSingleHostIndex));
    }

    public final ImmutableConfig withRandom(Random value) {
        if (this.random == value) {
            return this;
        }
        Random newValue = Objects.requireNonNull(value, "random");
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, this.channelFactory, this.rawConfig, this.uris, newValue, this.scheduler, this.ticker, this.maxQueueSize, this.overrideSingleHostIndex));
    }

    public final ImmutableConfig withScheduler(ScheduledExecutorService value) {
        if (this.scheduler == value) {
            return this;
        }
        ScheduledExecutorService newValue = Objects.requireNonNull(value, "scheduler");
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, this.channelFactory, this.rawConfig, this.uris, this.random, newValue, this.ticker, this.maxQueueSize, this.overrideSingleHostIndex));
    }

    public final ImmutableConfig withTicker(Ticker value) {
        if (this.ticker == value) {
            return this;
        }
        Ticker newValue = Objects.requireNonNull(value, "ticker");
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, this.channelFactory, this.rawConfig, this.uris, this.random, this.scheduler, newValue, this.maxQueueSize, this.overrideSingleHostIndex));
    }

    public final ImmutableConfig withMaxQueueSize(int value) {
        if (this.maxQueueSize == value) {
            return this;
        }
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, this.channelFactory, this.rawConfig, this.uris, this.random, this.scheduler, this.ticker, value, this.overrideSingleHostIndex));
    }

    public final ImmutableConfig withOverrideSingleHostIndex(int value) {
        Integer newValue = value;
        if (Objects.equals(this.overrideSingleHostIndex, newValue)) {
            return this;
        }
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, this.channelFactory, this.rawConfig, this.uris, this.random, this.scheduler, this.ticker, this.maxQueueSize, newValue));
    }

    public final ImmutableConfig withOverrideSingleHostIndex(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.overrideSingleHostIndex, value)) {
            return this;
        }
        return ImmutableConfig.validate(new ImmutableConfig(this.channelName, this.channelFactory, this.rawConfig, this.uris, this.random, this.scheduler, this.ticker, this.maxQueueSize, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfig && this.equalTo(0, (ImmutableConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfig another) {
        return this.channelName.equals(another.channelName) && this.channelFactory.equals(another.channelFactory) && this.rawConfig.equals(another.rawConfig) && this.clientConf.equals(another.clientConf) && this.uris.equals(another.uris) && this.mesh.equals((Object)another.mesh) && this.isConcurrencyLimitingEnabled == another.isConcurrencyLimitingEnabled && this.random.equals(another.random) && this.scheduler.equals(another.scheduler) && this.ticker.equals(another.ticker) && this.maxQueueSize == another.maxQueueSize && Objects.equals(this.overrideSingleHostIndex, another.overrideSingleHostIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelName.hashCode();
        h += (h << 5) + this.channelFactory.hashCode();
        h += (h << 5) + this.rawConfig.hashCode();
        h += (h << 5) + this.clientConf.hashCode();
        h += (h << 5) + this.uris.hashCode();
        h += (h << 5) + this.mesh.hashCode();
        h += (h << 5) + Booleans.hashCode(this.isConcurrencyLimitingEnabled);
        h += (h << 5) + this.random.hashCode();
        h += (h << 5) + this.scheduler.hashCode();
        h += (h << 5) + this.ticker.hashCode();
        h += (h << 5) + this.maxQueueSize;
        h += (h << 5) + Objects.hashCode(this.overrideSingleHostIndex);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Config").omitNullValues().add("channelName", this.channelName).add("channelFactory", this.channelFactory).add("rawConfig", this.rawConfig).add("clientConf", this.clientConf).add("uris", this.uris).add("mesh", (Object)this.mesh).add("isConcurrencyLimitingEnabled", this.isConcurrencyLimitingEnabled).add("random", this.random).add("scheduler", this.scheduler).add("ticker", this.ticker).add("maxQueueSize", this.maxQueueSize).add("overrideSingleHostIndex", this.overrideSingleHostIndex).toString();
    }

    private static ImmutableConfig validate(ImmutableConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableConfig copyOf(Config instance) {
        if (instance instanceof ImmutableConfig) {
            return (ImmutableConfig)instance;
        }
        return ImmutableConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Config", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_NAME = 1L;
        private static final long INIT_BIT_CHANNEL_FACTORY = 2L;
        private static final long INIT_BIT_RAW_CONFIG = 4L;
        private static final long OPT_BIT_MAX_QUEUE_SIZE = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String channelName;
        @Nullable
        private DialogueChannelFactory channelFactory;
        @Nullable
        private ClientConfiguration rawConfig;
        @Nullable
        private Refreshable<List<TargetUri>> uris;
        @Nullable
        private Random random;
        @Nullable
        private ScheduledExecutorService scheduler;
        @Nullable
        private Ticker ticker;
        private int maxQueueSize;
        @Nullable
        private Integer overrideSingleHostIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.channelName(instance.channelName());
            this.channelFactory(instance.channelFactory());
            this.rawConfig(instance.rawConfig());
            this.uris(instance.uris());
            this.random(instance.random());
            this.scheduler(instance.scheduler());
            this.ticker(instance.ticker());
            this.maxQueueSize(instance.maxQueueSize());
            OptionalInt overrideSingleHostIndexOptional = instance.overrideSingleHostIndex();
            if (overrideSingleHostIndexOptional.isPresent()) {
                this.overrideSingleHostIndex(overrideSingleHostIndexOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder channelName(String channelName) {
            this.channelName = Objects.requireNonNull(channelName, "channelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder channelFactory(DialogueChannelFactory channelFactory) {
            this.channelFactory = Objects.requireNonNull(channelFactory, "channelFactory");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rawConfig(ClientConfiguration rawConfig) {
            this.rawConfig = Objects.requireNonNull(rawConfig, "rawConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uris(Refreshable<List<TargetUri>> uris) {
            this.uris = Objects.requireNonNull(uris, "uris");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder random(Random random) {
            this.random = Objects.requireNonNull(random, "random");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scheduler(ScheduledExecutorService scheduler) {
            this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ticker(Ticker ticker) {
            this.ticker = Objects.requireNonNull(ticker, "ticker");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder overrideSingleHostIndex(int overrideSingleHostIndex) {
            this.overrideSingleHostIndex = overrideSingleHostIndex;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder overrideSingleHostIndex(OptionalInt overrideSingleHostIndex) {
            this.overrideSingleHostIndex = overrideSingleHostIndex.isPresent() ? Integer.valueOf(overrideSingleHostIndex.getAsInt()) : null;
            return this;
        }

        public ImmutableConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableConfig.validate(new ImmutableConfig(this));
        }

        private boolean maxQueueSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channelName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("channelFactory");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("rawConfig");
            }
            return "Cannot build Config, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Config", generator="Immutables")
    private final class InitShim {
        private byte clientConfBuildStage = 0;
        private ClientConfiguration clientConf;
        private byte urisBuildStage = 0;
        private Refreshable<List<TargetUri>> uris;
        private byte meshBuildStage = 0;
        private MeshMode mesh;
        private byte isConcurrencyLimitingEnabledBuildStage = 0;
        private boolean isConcurrencyLimitingEnabled;
        private byte randomBuildStage = 0;
        private Random random;
        private byte schedulerBuildStage = 0;
        private ScheduledExecutorService scheduler;
        private byte tickerBuildStage = 0;
        private Ticker ticker;
        private byte maxQueueSizeBuildStage = 0;
        private int maxQueueSize;

        private InitShim() {
        }

        ClientConfiguration clientConf() {
            if (this.clientConfBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientConfBuildStage == 0) {
                this.clientConfBuildStage = (byte)-1;
                this.clientConf = Objects.requireNonNull(ImmutableConfig.this.clientConfInitialize(), "clientConf");
                this.clientConfBuildStage = 1;
            }
            return this.clientConf;
        }

        Refreshable<List<TargetUri>> uris() {
            if (this.urisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.urisBuildStage == 0) {
                this.urisBuildStage = (byte)-1;
                this.uris = Objects.requireNonNull(ImmutableConfig.this.urisInitialize(), "uris");
                this.urisBuildStage = 1;
            }
            return this.uris;
        }

        void uris(Refreshable<List<TargetUri>> uris) {
            this.uris = uris;
            this.urisBuildStage = 1;
        }

        MeshMode mesh() {
            if (this.meshBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.meshBuildStage == 0) {
                this.meshBuildStage = (byte)-1;
                this.mesh = Objects.requireNonNull(ImmutableConfig.this.meshInitialize(), "mesh");
                this.meshBuildStage = 1;
            }
            return this.mesh;
        }

        boolean isConcurrencyLimitingEnabled() {
            if (this.isConcurrencyLimitingEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isConcurrencyLimitingEnabledBuildStage == 0) {
                this.isConcurrencyLimitingEnabledBuildStage = (byte)-1;
                this.isConcurrencyLimitingEnabled = ImmutableConfig.this.isConcurrencyLimitingEnabledInitialize();
                this.isConcurrencyLimitingEnabledBuildStage = 1;
            }
            return this.isConcurrencyLimitingEnabled;
        }

        Random random() {
            if (this.randomBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.randomBuildStage == 0) {
                this.randomBuildStage = (byte)-1;
                this.random = Objects.requireNonNull(ImmutableConfig.this.randomInitialize(), "random");
                this.randomBuildStage = 1;
            }
            return this.random;
        }

        void random(Random random) {
            this.random = random;
            this.randomBuildStage = 1;
        }

        ScheduledExecutorService scheduler() {
            if (this.schedulerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schedulerBuildStage == 0) {
                this.schedulerBuildStage = (byte)-1;
                this.scheduler = Objects.requireNonNull(ImmutableConfig.this.schedulerInitialize(), "scheduler");
                this.schedulerBuildStage = 1;
            }
            return this.scheduler;
        }

        void scheduler(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
            this.schedulerBuildStage = 1;
        }

        Ticker ticker() {
            if (this.tickerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tickerBuildStage == 0) {
                this.tickerBuildStage = (byte)-1;
                this.ticker = Objects.requireNonNull(ImmutableConfig.this.tickerInitialize(), "ticker");
                this.tickerBuildStage = 1;
            }
            return this.ticker;
        }

        void ticker(Ticker ticker) {
            this.ticker = ticker;
            this.tickerBuildStage = 1;
        }

        int maxQueueSize() {
            if (this.maxQueueSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxQueueSizeBuildStage == 0) {
                this.maxQueueSizeBuildStage = (byte)-1;
                this.maxQueueSize = ImmutableConfig.this.maxQueueSizeInitialize();
                this.maxQueueSizeBuildStage = 1;
            }
            return this.maxQueueSize;
        }

        void maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            this.maxQueueSizeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clientConfBuildStage == -1) {
                attributes.add("clientConf");
            }
            if (this.urisBuildStage == -1) {
                attributes.add("uris");
            }
            if (this.meshBuildStage == -1) {
                attributes.add("mesh");
            }
            if (this.isConcurrencyLimitingEnabledBuildStage == -1) {
                attributes.add("isConcurrencyLimitingEnabled");
            }
            if (this.randomBuildStage == -1) {
                attributes.add("random");
            }
            if (this.schedulerBuildStage == -1) {
                attributes.add("scheduler");
            }
            if (this.tickerBuildStage == -1) {
                attributes.add("ticker");
            }
            if (this.maxQueueSizeBuildStage == -1) {
                attributes.add("maxQueueSize");
            }
            return "Cannot build Config, attribute initializers form cycle " + attributes;
        }
    }
}

