/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import java.util.ArrayList;
import java.util.Objects;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.util.concurrent.SettableFuture;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.QueuedChannel;
import shadow.palantir.driver.com.palantir.tracing.DetachedSpan;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QueuedChannel.DeferredCall", generator="Immutables")
@Immutable
final class ImmutableDeferredCall
implements QueuedChannel.DeferredCall {
    private final Endpoint endpoint;
    private final Request request;
    private final SettableFuture<Response> response;
    private final DetachedSpan span;
    private final Timer.Context timer;

    private ImmutableDeferredCall(Endpoint endpoint, Request request, SettableFuture<Response> response, DetachedSpan span, Timer.Context timer) {
        this.endpoint = endpoint;
        this.request = request;
        this.response = response;
        this.span = span;
        this.timer = timer;
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public SettableFuture<Response> response() {
        return this.response;
    }

    @Override
    public DetachedSpan span() {
        return this.span;
    }

    @Override
    public Timer.Context timer() {
        return this.timer;
    }

    public final ImmutableDeferredCall withEndpoint(Endpoint value) {
        if (this.endpoint == value) {
            return this;
        }
        Endpoint newValue = Objects.requireNonNull(value, "endpoint");
        return new ImmutableDeferredCall(newValue, this.request, this.response, this.span, this.timer);
    }

    public final ImmutableDeferredCall withRequest(Request value) {
        if (this.request == value) {
            return this;
        }
        Request newValue = Objects.requireNonNull(value, "request");
        return new ImmutableDeferredCall(this.endpoint, newValue, this.response, this.span, this.timer);
    }

    public final ImmutableDeferredCall withResponse(SettableFuture<Response> value) {
        if (this.response == value) {
            return this;
        }
        SettableFuture<Response> newValue = Objects.requireNonNull(value, "response");
        return new ImmutableDeferredCall(this.endpoint, this.request, newValue, this.span, this.timer);
    }

    public final ImmutableDeferredCall withSpan(DetachedSpan value) {
        if (this.span == value) {
            return this;
        }
        DetachedSpan newValue = Objects.requireNonNull(value, "span");
        return new ImmutableDeferredCall(this.endpoint, this.request, this.response, newValue, this.timer);
    }

    public final ImmutableDeferredCall withTimer(Timer.Context value) {
        if (this.timer == value) {
            return this;
        }
        Timer.Context newValue = Objects.requireNonNull(value, "timer");
        return new ImmutableDeferredCall(this.endpoint, this.request, this.response, this.span, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeferredCall && this.equalTo(0, (ImmutableDeferredCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeferredCall another) {
        return this.endpoint.equals(another.endpoint) && this.request.equals(another.request) && this.response.equals(another.response) && this.span.equals(another.span) && this.timer.equals(another.timer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.endpoint.hashCode();
        h += (h << 5) + this.request.hashCode();
        h += (h << 5) + this.response.hashCode();
        h += (h << 5) + this.span.hashCode();
        h += (h << 5) + this.timer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("DeferredCall").omitNullValues().add("endpoint", this.endpoint).add("request", this.request).add("response", this.response).add("span", this.span).add("timer", this.timer).toString();
    }

    public static ImmutableDeferredCall copyOf(QueuedChannel.DeferredCall instance) {
        if (instance instanceof ImmutableDeferredCall) {
            return (ImmutableDeferredCall)instance;
        }
        return new QueuedChannel.DeferredCall.Builder().from(instance).build();
    }

    @Generated(from="QueuedChannel.DeferredCall", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_ENDPOINT = 1L;
        private static final long INIT_BIT_REQUEST = 2L;
        private static final long INIT_BIT_RESPONSE = 4L;
        private static final long INIT_BIT_SPAN = 8L;
        private static final long INIT_BIT_TIMER = 16L;
        private long initBits = 31L;
        @Nullable
        private Endpoint endpoint;
        @Nullable
        private Request request;
        @Nullable
        private SettableFuture<Response> response;
        @Nullable
        private DetachedSpan span;
        @Nullable
        private Timer.Context timer;

        public Builder() {
            if (!(this instanceof QueuedChannel.DeferredCall.Builder)) {
                throw new UnsupportedOperationException("Use: new QueuedChannel.DeferredCall.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final QueuedChannel.DeferredCall.Builder from(QueuedChannel.DeferredCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.endpoint(instance.endpoint());
            this.request(instance.request());
            this.response(instance.response());
            this.span(instance.span());
            this.timer(instance.timer());
            return (QueuedChannel.DeferredCall.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueuedChannel.DeferredCall.Builder endpoint(Endpoint endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (QueuedChannel.DeferredCall.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueuedChannel.DeferredCall.Builder request(Request request) {
            this.request = Objects.requireNonNull(request, "request");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (QueuedChannel.DeferredCall.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueuedChannel.DeferredCall.Builder response(SettableFuture<Response> response) {
            this.response = Objects.requireNonNull(response, "response");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (QueuedChannel.DeferredCall.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueuedChannel.DeferredCall.Builder span(DetachedSpan span) {
            this.span = Objects.requireNonNull(span, "span");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (QueuedChannel.DeferredCall.Builder)this;
        }

        @CanIgnoreReturnValue
        public final QueuedChannel.DeferredCall.Builder timer(Timer.Context timer) {
            this.timer = Objects.requireNonNull(timer, "timer");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (QueuedChannel.DeferredCall.Builder)this;
        }

        public ImmutableDeferredCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeferredCall(this.endpoint, this.request, this.response, this.span, this.timer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("endpoint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("request");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("response");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("span");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("timer");
            }
            return "Cannot build DeferredCall, some of required attributes are not set " + attributes;
        }
    }
}

