/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.List;

enum MeshMode {
    DEFAULT_NO_MESH,
    USE_EXTERNAL_MESH;

    private static final String MESH_PREFIX = "mesh-";

    static MeshMode fromUris(List<String> uris, SafeArg<String> channelName) {
        long meshUris = uris.stream().filter(s -> s.startsWith(MESH_PREFIX)).count();
        long normalUris = uris.stream().filter(s -> !s.startsWith(MESH_PREFIX)).count();
        if (meshUris == 0L) {
            return DEFAULT_NO_MESH;
        }
        if (meshUris != 1L) {
            throw new SafeIllegalStateException("Not expecting multiple 'mesh-' prefixed uris - please double-check the uris", SafeArg.of("meshUris", meshUris), SafeArg.of("normalUris", normalUris), channelName);
        }
        if (normalUris != 0L) {
            throw new SafeIllegalStateException("When a 'mesh-' prefixed uri is present, there should not be any normal uris - please double check the uris", SafeArg.of("meshUris", meshUris), SafeArg.of("normalUris", normalUris), channelName);
        }
        return USE_EXTERNAL_MESH;
    }

    public static String stripMeshPrefix(String input) {
        return input.startsWith(MESH_PREFIX) ? input.substring(MESH_PREFIX.length()) : input;
    }
}

