/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;

final class NeverThrowChannel
implements Channel {
    private static final SafeLogger log = SafeLoggerFactory.get(NeverThrowChannel.class);
    private final Channel delegate;

    NeverThrowChannel(Channel delegate) {
        this.delegate = delegate;
    }

    @Override
    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        try {
            return this.delegate.execute(endpoint, request);
        }
        catch (Error | RuntimeException e) {
            log.error("Dialogue channels should never throw. This may be a bug in the channel implementation", e);
            return Futures.immediateFailedFuture(e);
        }
    }

    public String toString() {
        return "NeverThrowChannel{" + this.delegate + "}";
    }
}

