/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;

final class NeverThrowEndpointChannel
implements EndpointChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(NeverThrowEndpointChannel.class);
    private final EndpointChannel proceed;

    NeverThrowEndpointChannel(EndpointChannel proceed) {
        this.proceed = proceed;
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        try {
            return this.proceed.execute(request);
        }
        catch (Error | RuntimeException e) {
            log.error("Dialogue channels should never throw. This may be a bug in the channel implementation", e);
            return Futures.immediateFailedFuture(e);
        }
    }

    public String toString() {
        return "NeverThrowEndpointChannel{" + this.proceed + "}";
    }
}

