/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;

final class NeverThrowLimitedChannel
implements LimitedChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(NeverThrowLimitedChannel.class);
    private final LimitedChannel delegate;

    NeverThrowLimitedChannel(LimitedChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        try {
            return this.delegate.maybeExecute(endpoint, request, limitEnforcement);
        }
        catch (Error | RuntimeException e) {
            log.error("Dialogue channels should never throw. This may be a bug in the channel implementation", e);
            return Optional.of(Futures.immediateFailedFuture(e));
        }
    }

    public String toString() {
        return "NeverThrowLimitedChannel{" + this.delegate + "}";
    }
}

