/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.BalancedNodeSelectionStrategyChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueNodeSelectionStrategy;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueNodeselectionMetrics;
import shadow.palantir.driver.com.palantir.dialogue.core.DialoguePinuntilerrorMetrics;
import shadow.palantir.driver.com.palantir.dialogue.core.ImmutableNodeSelectionChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.NodeSelectionStrategyChooser;
import shadow.palantir.driver.com.palantir.dialogue.core.PinUntilErrorNodeSelectionStrategyChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.SafeUnknownHostException;
import shadow.palantir.driver.com.palantir.dialogue.core.StickyAttachments;
import shadow.palantir.driver.com.palantir.dialogue.core.SupplierChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.ZeroUriNodeSelectionChannel;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.immutables.value.Value;

final class NodeSelectionStrategyChannel
implements LimitedChannel {
    private static final String NODE_SELECTION_HEADER = "Node-Selection-Strategy";
    private final FutureCallback<Response> callback = new NodeSelectionCallback();
    private final AtomicReference<NodeSelectionChannel> nodeSelectionStrategy = new AtomicReference();
    private final NodeSelectionStrategyChooser strategySelector;
    private final String channelName;
    private final Random random;
    private final Ticker tick;
    private final TaggedMetricRegistry metrics;
    private final DialogueNodeselectionMetrics nodeSelectionMetrics;
    private final ImmutableList<LimitedChannel> channels;
    private final LimitedChannel delegate = new SupplierChannel(() -> this.nodeSelectionStrategy.get().channel());

    @VisibleForTesting
    NodeSelectionStrategyChannel(NodeSelectionStrategyChooser strategySelector, DialogueNodeSelectionStrategy initialStrategy, String channelName, Random random, Ticker tick, TaggedMetricRegistry metrics, ImmutableList<LimitedChannel> channels) {
        this.strategySelector = strategySelector;
        this.channelName = channelName;
        this.random = random;
        this.tick = tick;
        this.metrics = metrics;
        this.nodeSelectionMetrics = DialogueNodeselectionMetrics.of(metrics);
        this.channels = channels;
        this.nodeSelectionStrategy.set(this.createNodeSelectionChannel(null, initialStrategy));
    }

    static LimitedChannel create(Config cf, ImmutableList<LimitedChannel> channels) {
        if (channels.isEmpty()) {
            if (cf.clientConf().uris().isEmpty()) {
                return new StickyChannelHandler(new ZeroUriNodeSelectionChannel(endpoint -> new SafeIllegalStateException("There are no URIs configured to handle requests", SafeArg.of("channel", cf.channelName()), SafeArg.of("service", endpoint.serviceName()), SafeArg.of("endpoint", endpoint.endpointName()))));
            }
            return new StickyChannelHandler(new ZeroUriNodeSelectionChannel(endpoint -> new SafeUnknownHostException("There were no DNS results for this host", SafeArg.of("channel", cf.channelName()), SafeArg.of("service", endpoint.serviceName()), SafeArg.of("endpoint", endpoint.endpointName()))));
        }
        if (channels.size() == 1) {
            return new StickyChannelHandler(new StickyTokenHandler((LimitedChannel)channels.get(0)));
        }
        return new NodeSelectionStrategyChannel(NodeSelectionStrategyChannel::getFirstKnownStrategy, DialogueNodeSelectionStrategy.of(cf.clientConf().nodeSelectionStrategy()), cf.channelName(), cf.random(), cf.ticker(), cf.clientConf().taggedMetricRegistry(), channels);
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        Optional<ListenableFuture<Response>> maybe = StickyChannelHandler.maybeExecute(this.delegate, endpoint, request, limitEnforcement);
        if (!maybe.isPresent()) {
            return Optional.empty();
        }
        ListenableFuture<Response> wrappedFuture = DialogueFutures.addDirectCallback(maybe.get(), this.callback);
        return Optional.of(wrappedFuture);
    }

    private NodeSelectionChannel createNodeSelectionChannel(@Nullable LimitedChannel previousNodeSelectionStrategy, DialogueNodeSelectionStrategy strategy) {
        NodeSelectionChannel.Builder channelBuilder = NodeSelectionChannel.builder().strategy(strategy);
        switch (strategy) {
            case PIN_UNTIL_ERROR: 
            case PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE: {
                DialoguePinuntilerrorMetrics pinuntilerrorMetrics = DialoguePinuntilerrorMetrics.of(this.metrics);
                if (previousNodeSelectionStrategy instanceof PinUntilErrorNodeSelectionStrategyChannel) {
                    PinUntilErrorNodeSelectionStrategyChannel previousPinUntilError = (PinUntilErrorNodeSelectionStrategyChannel)previousNodeSelectionStrategy;
                    return channelBuilder.channel(PinUntilErrorNodeSelectionStrategyChannel.of(Optional.of(previousPinUntilError.getCurrentChannel()), strategy, this.channels, pinuntilerrorMetrics, this.random, this.tick, this.channelName)).build();
                }
                return channelBuilder.channel(PinUntilErrorNodeSelectionStrategyChannel.of(Optional.empty(), strategy, this.channels, pinuntilerrorMetrics, this.random, this.tick, this.channelName)).build();
            }
            case BALANCED: {
                return channelBuilder.channel(new BalancedNodeSelectionStrategyChannel(this.channels, this.random, this.tick, this.metrics, this.channelName)).build();
            }
        }
        throw new SafeRuntimeException("Unknown NodeSelectionStrategy", SafeArg.of("unknown", strategy));
    }

    @VisibleForTesting
    static Optional<DialogueNodeSelectionStrategy> getFirstKnownStrategy(List<DialogueNodeSelectionStrategy> strategies) {
        for (DialogueNodeSelectionStrategy strategy : strategies) {
            if (strategy.equals((Object)DialogueNodeSelectionStrategy.UNKNOWN)) continue;
            return Optional.of(strategy);
        }
        return Optional.empty();
    }

    public String toString() {
        return "NodeSelectionStrategyChannel{" + this.nodeSelectionStrategy + "}";
    }

    private static final class StickyTokenHandler
    implements LimitedChannel {
        private final LimitedChannel delegate;

        StickyTokenHandler(LimitedChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
            return StickyAttachments.maybeAddStickyToken(this.delegate, endpoint, request, limitEnforcement);
        }
    }

    private static final class StickyChannelHandler
    implements LimitedChannel {
        private final LimitedChannel delegate;

        StickyChannelHandler(LimitedChannel delegate) {
            this.delegate = delegate;
        }

        static Optional<ListenableFuture<Response>> maybeExecute(LimitedChannel channel, Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
            return StickyAttachments.maybeExecuteOnSticky(channel, endpoint, request, limitEnforcement);
        }

        @Override
        public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
            return StickyChannelHandler.maybeExecute(this.delegate, endpoint, request, limitEnforcement);
        }
    }

    private final class NodeSelectionCallback
    implements FutureCallback<Response> {
        private NodeSelectionCallback() {
        }

        @Override
        public void onSuccess(Response result) {
            result.getFirstHeader(NodeSelectionStrategyChannel.NODE_SELECTION_HEADER).ifPresent(this::consumeStrategy);
        }

        @Override
        public void onFailure(Throwable _unused) {
        }

        private void consumeStrategy(String strategy) {
            Optional<DialogueNodeSelectionStrategy> maybeStrategy = NodeSelectionStrategyChannel.this.strategySelector.updateAndGet(DialogueNodeSelectionStrategy.fromHeader(strategy));
            if (!maybeStrategy.isPresent()) {
                return;
            }
            DialogueNodeSelectionStrategy fromServer = maybeStrategy.get();
            if (fromServer.equals((Object)NodeSelectionStrategyChannel.this.nodeSelectionStrategy.get().strategy())) {
                return;
            }
            NodeSelectionStrategyChannel.this.nodeSelectionMetrics.strategy().channelName(NodeSelectionStrategyChannel.this.channelName).strategy(fromServer.toString()).build().mark();
            NodeSelectionStrategyChannel.this.nodeSelectionStrategy.getAndUpdate(prevChannel -> NodeSelectionStrategyChannel.this.createNodeSelectionChannel(prevChannel.channel(), fromServer));
        }
    }

    @Value.Immutable
    static interface NodeSelectionChannel {
        public DialogueNodeSelectionStrategy strategy();

        public LimitedChannel channel();

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends ImmutableNodeSelectionChannel.Builder {
        }
    }
}

