/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueNodeSelectionStrategy;
import shadow.palantir.driver.com.palantir.dialogue.core.DialoguePinuntilerrorMetrics;
import shadow.palantir.driver.com.palantir.dialogue.core.ImmutablePinChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.Responses;
import shadow.palantir.driver.com.palantir.dialogue.core.StickyAttachments;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.immutables.value.Value;

final class PinUntilErrorNodeSelectionStrategyChannel
implements LimitedChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(PinUntilErrorNodeSelectionStrategyChannel.class);
    private static final Duration RESHUFFLE_EVERY = Duration.ofMinutes(10L);
    private final AtomicInteger currentPin;
    private final NodeList nodeList;
    private final Instrumentation instrumentation;

    @VisibleForTesting
    PinUntilErrorNodeSelectionStrategyChannel(NodeList nodeList, int initialPin, DialoguePinuntilerrorMetrics metrics, String channelName) {
        this.nodeList = nodeList;
        this.currentPin = new AtomicInteger(initialPin);
        this.instrumentation = new Instrumentation(nodeList.size(), metrics, channelName);
        if (nodeList.size() < 2) {
            throw new SafeIllegalArgumentException("PinUntilError is pointless if you have zero or 1 channels. Use an always throwing channel or just pick the only channel in the list.", new Arg[0]);
        }
        if (0 > initialPin || initialPin >= nodeList.size()) {
            throw new SafeIllegalArgumentException("initialHost must be a valid index into nodeList", SafeArg.of("initialHost", initialPin));
        }
    }

    static PinUntilErrorNodeSelectionStrategyChannel of(Optional<LimitedChannel> initialChannel, DialogueNodeSelectionStrategy strategy, List<LimitedChannel> channels, DialoguePinuntilerrorMetrics metrics, Random random, Ticker ticker, String channelName) {
        List pinChannels = IntStream.range(0, channels.size()).mapToObj(index -> ImmutablePinChannel.builder().delegate((LimitedChannel)channels.get(index)).stableIndex(index).build()).collect(ImmutableList.toImmutableList());
        ImmutableList<PinChannel> initialShuffle = PinUntilErrorNodeSelectionStrategyChannel.shuffleImmutableList(pinChannels, random);
        int initialPin = initialChannel.map(limitedChannel -> Math.max(0, initialShuffle.indexOf(limitedChannel))).orElse(0);
        if (strategy == DialogueNodeSelectionStrategy.PIN_UNTIL_ERROR) {
            ReshufflingNodeList shuffling = ReshufflingNodeList.of(initialShuffle, random, ticker, metrics, channelName);
            return new PinUntilErrorNodeSelectionStrategyChannel(shuffling, initialPin, metrics, channelName);
        }
        if (strategy == DialogueNodeSelectionStrategy.PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE) {
            ConstantNodeList constant = new ConstantNodeList(initialShuffle);
            return new PinUntilErrorNodeSelectionStrategyChannel(constant, initialPin, metrics, channelName);
        }
        throw new SafeIllegalArgumentException("Unsupported NodeSelectionStrategy", SafeArg.of("strategy", strategy));
    }

    LimitedChannel getCurrentChannel() {
        return this.nodeList.get(this.currentPin.get());
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        final int pin = this.currentPin.get();
        final PinChannel channel = this.nodeList.get(pin);
        Optional<ListenableFuture<Response>> maybeResponse = StickyAttachments.maybeAddStickyToken(channel, endpoint, request, limitEnforcement);
        if (!maybeResponse.isPresent()) {
            return Optional.empty();
        }
        DialogueFutures.addDirectCallback(maybeResponse.get(), new FutureCallback<Response>(){

            @Override
            public void onSuccess(Response response) {
                if (Responses.isServerErrorRange(response) || Responses.isQosStatus(response) && !Responses.isTooManyRequests(response)) {
                    OptionalInt next = PinUntilErrorNodeSelectionStrategyChannel.this.incrementHostIfNecessary(pin);
                    PinUntilErrorNodeSelectionStrategyChannel.this.instrumentation.receivedErrorStatus(pin, channel, response, next);
                } else {
                    PinUntilErrorNodeSelectionStrategyChannel.this.instrumentation.successfulResponse(channel.stableIndex());
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                OptionalInt next = PinUntilErrorNodeSelectionStrategyChannel.this.incrementHostIfNecessary(pin);
                PinUntilErrorNodeSelectionStrategyChannel.this.instrumentation.receivedThrowable(pin, channel, throwable, next);
            }
        });
        return maybeResponse;
    }

    private OptionalInt incrementHostIfNecessary(int pin) {
        int nextIndex = (pin + 1) % this.nodeList.size();
        boolean saved = this.currentPin.compareAndSet(pin, nextIndex);
        return saved ? OptionalInt.of(nextIndex) : OptionalInt.empty();
    }

    private static <T> ImmutableList<T> shuffleImmutableList(List<T> sourceList, Random random) {
        ArrayList<T> mutableList = new ArrayList<T>(sourceList);
        Collections.shuffle(mutableList, random);
        return ImmutableList.copyOf(mutableList);
    }

    private static final class Instrumentation {
        @Nullable
        private final Meter[] successesPerHost;
        private final Meter reshuffleMeter;
        private final Meter nextNodeBecauseResponseCode;
        private final Meter nextNodeBecauseThrowable;
        private final String channelName;
        private final int numChannels;

        Instrumentation(int numChannels, DialoguePinuntilerrorMetrics metrics, String channelName) {
            this.numChannels = numChannels;
            this.channelName = channelName;
            this.reshuffleMeter = metrics.reshuffle(channelName);
            this.nextNodeBecauseResponseCode = metrics.nextNode().channelName(channelName).reason("responseCode").build();
            this.nextNodeBecauseThrowable = metrics.nextNode().channelName(channelName).reason("throwable").build();
            this.successesPerHost = numChannels < 10 ? (Meter[])IntStream.range(0, numChannels).mapToObj(index -> metrics.success().channelName(channelName).hostIndex(Integer.toString(index)).build()).toArray(Meter[]::new) : null;
        }

        private void reshuffled(ImmutableList<PinChannel> newList, long intervalWithJitter) {
            this.reshuffleMeter.mark();
            if (log.isDebugEnabled()) {
                log.debug("Reshuffled channels {} {} {} {}", SafeArg.of("nextReshuffle", Duration.ofNanos(intervalWithJitter)), UnsafeArg.of("newList", newList), SafeArg.of("channelName", this.channelName), SafeArg.of("numChannels", this.numChannels));
            }
        }

        private void receivedErrorStatus(int pin, PinChannel channel, Response response, OptionalInt next) {
            if (next.isPresent()) {
                this.nextNodeBecauseResponseCode.mark();
                if (log.isInfoEnabled()) {
                    log.info("Received error status code, switching to next channel", SafeArg.of("status", response.code()), SafeArg.of("stableIndex", channel.stableIndex()), SafeArg.of("pin", pin), UnsafeArg.of("channel", channel), SafeArg.of("nextIndex", next.getAsInt()), SafeArg.of("channelName", this.channelName), SafeArg.of("numChannels", this.numChannels));
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Received error status code, but we've already switched", SafeArg.of("status", response.code()), SafeArg.of("stableIndex", channel.stableIndex()), SafeArg.of("pin", pin), UnsafeArg.of("channel", channel), SafeArg.of("channelName", this.channelName), SafeArg.of("numChannels", this.numChannels));
            }
        }

        private void receivedThrowable(int pin, PinChannel channel, Throwable throwable, OptionalInt next) {
            if (next.isPresent()) {
                this.nextNodeBecauseThrowable.mark();
                if (log.isInfoEnabled()) {
                    Throwable throwableToLog = log.isDebugEnabled() ? throwable : null;
                    log.info("Received throwable, switching to next channel", SafeArg.of("stableIndex", channel.stableIndex()), SafeArg.of("pin", pin), UnsafeArg.of("channel", channel), SafeArg.of("nextIndex", next.getAsInt()), SafeArg.of("channelName", this.channelName), SafeArg.of("numChannels", this.numChannels), throwableToLog);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Received throwable, but already switched", SafeArg.of("pin", pin), SafeArg.of("stableIndex", channel.stableIndex()), UnsafeArg.of("channel", channel), SafeArg.of("channelName", this.channelName), SafeArg.of("numChannels", this.numChannels), throwable);
            }
        }

        private void successfulResponse(int currentIndex) {
            if (this.successesPerHost != null) {
                this.successesPerHost[currentIndex].mark();
            }
        }
    }

    @VisibleForTesting
    static final class ReshufflingNodeList
    implements NodeList {
        private final Ticker clock;
        private final Random random;
        private final long intervalWithJitter;
        private final int channelsSize;
        private final Instrumentation instrumentation;
        private final AtomicLong nextReshuffle;
        private volatile ImmutableList<PinChannel> channels;

        static ReshufflingNodeList of(ImmutableList<PinChannel> channels, Random random, Ticker clock, DialoguePinuntilerrorMetrics metrics, String channelName) {
            long intervalWithJitter = RESHUFFLE_EVERY.plus(Duration.ofSeconds(random.nextInt(60) - 30)).toNanos();
            AtomicLong nextReshuffle = new AtomicLong(clock.read() + intervalWithJitter);
            return new ReshufflingNodeList(channels, random, clock, metrics, intervalWithJitter, nextReshuffle, channelName);
        }

        private ReshufflingNodeList(ImmutableList<PinChannel> channels, Random random, Ticker clock, DialoguePinuntilerrorMetrics metrics, long intervalWithJitter, AtomicLong nextReshuffle, String channelName) {
            this.channels = channels;
            this.channelsSize = channels.size();
            this.nextReshuffle = nextReshuffle;
            this.intervalWithJitter = intervalWithJitter;
            this.random = random;
            this.clock = clock;
            this.instrumentation = new Instrumentation(this.channelsSize, metrics, channelName);
        }

        @Override
        public PinChannel get(int index) {
            this.reshuffleChannelsIfNecessary();
            return (PinChannel)this.channels.get(index);
        }

        @Override
        public int size() {
            return this.channelsSize;
        }

        private void reshuffleChannelsIfNecessary() {
            long reshuffleTime = this.nextReshuffle.get();
            if (this.clock.read() < reshuffleTime) {
                return;
            }
            if (this.nextReshuffle.compareAndSet(reshuffleTime, this.clock.read() + this.intervalWithJitter)) {
                ImmutableList<PinChannel> newList = PinUntilErrorNodeSelectionStrategyChannel.shuffleImmutableList(this.channels, this.random);
                this.instrumentation.reshuffled(newList, this.intervalWithJitter);
                this.channels = newList;
            }
        }

        public String toString() {
            return "ReshufflingNodeList{channels=" + this.channels + ", nextReshuffle=" + this.nextReshuffle + ", intervalWithJitter=" + this.intervalWithJitter + "}";
        }
    }

    @VisibleForTesting
    static final class ConstantNodeList
    implements NodeList {
        private final List<PinChannel> channels;

        ConstantNodeList(List<PinChannel> channels) {
            this.channels = channels;
        }

        @Override
        public PinChannel get(int index) {
            return this.channels.get(index);
        }

        @Override
        public int size() {
            return this.channels.size();
        }

        public String toString() {
            return "ConstantNodeList{" + this.channels + "}";
        }
    }

    @Value.Immutable
    static interface PinChannel
    extends LimitedChannel {
        public LimitedChannel delegate();

        @Value.Auxiliary
        public int stableIndex();

        @Override
        default public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
            return this.delegate().maybeExecute(endpoint, request, limitEnforcement);
        }
    }

    static interface NodeList {
        public PinChannel get(int var1);

        public int size();
    }
}

