/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import shadow.palantir.driver.com.google.common.collect.ListMultimap;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;

final class RangeAcceptsIdentityEncodingChannel
implements EndpointChannel {
    private final EndpointChannel delegate;

    RangeAcceptsIdentityEncodingChannel(EndpointChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        Request delegateRequest = RangeAcceptsIdentityEncodingChannel.isRangeRequestWithoutAcceptEncoding(request) ? RangeAcceptsIdentityEncodingChannel.withIdentityEncoding(request) : request;
        return this.delegate.execute(delegateRequest);
    }

    private static boolean isRangeRequestWithoutAcceptEncoding(Request request) {
        ListMultimap<String, String> requestHeaders = request.headerParams();
        return requestHeaders.containsKey("Range") && !requestHeaders.containsKey("Accept-Encoding");
    }

    private static Request withIdentityEncoding(Request request) {
        return Request.builder().from(request).putHeaderParams("Accept-Encoding", "identity").build();
    }
}

