/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.RequestBody;
import shadow.palantir.driver.com.palantir.dialogue.Response;

final class RequestBodyValidationChannel
implements EndpointChannel {
    private static final Consumer<RequestBody> BODY_VALIDATOR = RequestBodyValidationChannel::validate;
    private final EndpointChannel delegate;

    RequestBodyValidationChannel(EndpointChannel delegate) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate is required");
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        RequestBodyValidationChannel.validate(request);
        return this.delegate.execute(request);
    }

    private static void validate(Request request) {
        Optional<RequestBody> body = request.body();
        body.ifPresent(BODY_VALIDATOR);
    }

    private static void validate(RequestBody body) {
        Preconditions.checkNotNull(body.contentType(), "RequestBody.contentType is required");
    }
}

