/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import shadow.palantir.driver.com.palantir.dialogue.Response;

final class Responses {
    static boolean isRetryOther(Response response) {
        return response.code() == 308 && response.getFirstHeader("Location").isPresent();
    }

    static boolean isTooManyRequests(Response response) {
        return response.code() == 429;
    }

    static boolean isUnavailable(Response response) {
        return response.code() == 503;
    }

    static boolean isQosStatus(Response response) {
        return Responses.isRetryOther(response) || Responses.isTooManyRequests(response) || Responses.isUnavailable(response);
    }

    static boolean isServerErrorRange(Response response) {
        return response.code() / 100 == 5;
    }

    static boolean isInternalServerError(Response response) {
        return response.code() == 500;
    }

    static boolean isSuccess(Response response) {
        return response.code() / 100 == 2;
    }

    static boolean isClientError(Response response) {
        return response.code() / 100 == 4;
    }

    private Responses() {
    }
}

