/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.RateLimiter;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.MeshMode;
import shadow.palantir.driver.com.palantir.dialogue.core.Responses;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.javax.annotation.CheckForNull;

final class RetryOtherValidatingChannel
implements Channel {
    private static final SafeLogger log = SafeLoggerFactory.get(RetryOtherValidatingChannel.class);
    private static final RateLimiter VALIDATION_FAILED_LOGGING_LIMITER = RateLimiter.create(1.0);
    private final Channel delegate;
    private final Set<String> hosts;
    private final FutureCallback<Response> callback;
    private final Consumer<String> failureReporter;

    RetryOtherValidatingChannel(Channel delegate, Set<String> hosts) {
        this(delegate, hosts, RetryOtherValidatingChannel.failureReporter(hosts));
    }

    @VisibleForTesting
    RetryOtherValidatingChannel(Channel delegate, Set<String> hosts, Consumer<String> failureReporter) {
        this.delegate = delegate;
        this.hosts = hosts;
        this.callback = new FutureCallback<Response>(){

            @Override
            public void onSuccess(Response result) {
                RetryOtherValidatingChannel.this.validateRetryOther(result);
            }

            @Override
            public void onFailure(Throwable _throwable) {
            }
        };
        this.failureReporter = failureReporter;
    }

    @Override
    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        return DialogueFutures.addDirectCallback(this.delegate.execute(endpoint, request), this.callback);
    }

    private void validateRetryOther(Response response) {
        String retryOtherUri;
        if (!Responses.isRetryOther(response)) {
            return;
        }
        Optional<String> maybeRetryOtherUri = response.getFirstHeader("Location");
        if (maybeRetryOtherUri.isPresent() && !this.isValidUri(retryOtherUri = maybeRetryOtherUri.get())) {
            this.failureReporter.accept(retryOtherUri);
        }
    }

    private boolean isValidUri(String uri) {
        String maybeHost = RetryOtherValidatingChannel.maybeParseHost(uri);
        return maybeHost != null && this.hosts.contains(maybeHost);
    }

    static Channel create(Config cf, Channel delegate) {
        try {
            Set hosts = cf.clientConf().uris().stream().map(RetryOtherValidatingChannel::strictParseHost).collect(ImmutableSet.toImmutableSet());
            return new RetryOtherValidatingChannel(delegate, hosts);
        }
        catch (RuntimeException e) {
            log.warn("Could not parse uris, turning off Location header validation", e);
            return delegate;
        }
    }

    @VisibleForTesting
    static String strictParseHost(String uri) {
        String maybeHost = RetryOtherValidatingChannel.maybeParseHost(uri);
        if (maybeHost != null) {
            return maybeHost;
        }
        throw new SafeIllegalArgumentException("Failed to parse URI", UnsafeArg.of("uri", uri));
    }

    @CheckForNull
    @VisibleForTesting
    static String maybeParseHost(String uri) {
        String normalized = MeshMode.stripMeshPrefix(uri);
        try {
            URL parsed = new URL(normalized);
            return parsed.getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static Consumer<String> failureReporter(Set<String> hosts) {
        UnsafeArg<Set<String>> unsafeUris = UnsafeArg.of("uris", hosts);
        return retryOtherUri -> {
            if (VALIDATION_FAILED_LOGGING_LIMITER.tryAcquire()) {
                log.info("Invalid Location header value {} {}", UnsafeArg.of("location", retryOtherUri), unsafeUris);
            }
        };
    }
}

