/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.exceptions.SafeExceptions;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import shadow.palantir.driver.com.google.errorprone.annotations.CompileTimeConstant;

final class SafeUnknownHostException
extends UnknownHostException
implements SafeLoggable {
    @CompileTimeConstant
    private final String logMessage;
    private final List<Arg<?>> arguments;

    SafeUnknownHostException(@CompileTimeConstant String message, Arg<?> ... arguments) {
        super(SafeExceptions.renderMessage(message, arguments));
        this.logMessage = message;
        this.arguments = Collections.unmodifiableList(Arrays.asList(arguments));
    }

    @Override
    @Safe
    public String getLogMessage() {
        return this.logMessage;
    }

    @Override
    public List<Arg<?>> getArgs() {
        return this.arguments;
    }
}

