/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.util.Optional;
import java.util.function.Consumer;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.RequestAttachmentKey;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.ResponseAttachmentKey;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;

final class StickyAttachments {
    private static final ListenableFuture<Response> VALIDATION_FAILURE_EXCEPTION_FUTURE = Futures.immediateFailedFuture(new SafeRuntimeException("Requested sticky token on request but token not present on response", new Arg[0]));
    @VisibleForTesting
    static final RequestAttachmentKey<Boolean> REQUEST_STICKY_TOKEN = RequestAttachmentKey.create(Boolean.class);
    @VisibleForTesting
    static final ResponseAttachmentKey<StickyTarget> STICKY_TOKEN = ResponseAttachmentKey.create(StickyTarget.class);
    @VisibleForTesting
    static final RequestAttachmentKey<StickyTarget> STICKY = RequestAttachmentKey.create(StickyTarget.class);

    private StickyAttachments() {
    }

    @CheckReturnValue
    static Optional<ListenableFuture<Response>> maybeAddStickyToken(LimitedChannel channel, Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        if (StickyAttachments.hasRequestStickyToken(request)) {
            return channel.maybeExecute(endpoint, request, limitEnforcement).map(future -> DialogueFutures.transform(future, response -> {
                response.attachments().put(STICKY_TOKEN, channel::maybeExecute);
                return response;
            }));
        }
        return channel.maybeExecute(endpoint, request, limitEnforcement);
    }

    static Optional<ListenableFuture<Response>> maybeExecuteAndValidateRequestStickyToken(LimitedChannel channel, Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        if (StickyAttachments.hasRequestStickyToken(request)) {
            return channel.maybeExecute(endpoint, request, limitEnforcement).map(future -> DialogueFutures.transformAsync(future, response -> {
                if (response.attachments().getOrDefault(STICKY_TOKEN, null) != null) {
                    return Futures.immediateFuture(response);
                }
                response.close();
                return VALIDATION_FAILURE_EXCEPTION_FUTURE;
            }));
        }
        return channel.maybeExecute(endpoint, request, limitEnforcement);
    }

    static Optional<ListenableFuture<Response>> maybeExecuteOnSticky(LimitedChannel fallback, Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        StickyTarget target = request.attachments().getOrDefault(STICKY, null);
        if (target != null) {
            return target.maybeExecute(endpoint, request, limitEnforcement);
        }
        return fallback.maybeExecute(endpoint, request, limitEnforcement);
    }

    static void requestStickyToken(Request request) {
        request.attachments().put(REQUEST_STICKY_TOKEN, Boolean.TRUE);
    }

    static Consumer<Request> copyStickyTarget(Response response) {
        StickyTarget stickyTarget = Preconditions.checkNotNull(response.attachments().getOrDefault(STICKY_TOKEN, null), "stickyToken");
        return request -> request.attachments().put(STICKY, stickyTarget);
    }

    private static boolean hasRequestStickyToken(Request request) {
        return Boolean.TRUE.equals(request.attachments().getOrDefault(REQUEST_STICKY_TOKEN, Boolean.FALSE));
    }

    @VisibleForTesting
    static interface StickyTarget {
        public Optional<ListenableFuture<Response>> maybeExecute(Endpoint var1, Request var2, LimitedChannel.LimitEnforcement var3);
    }
}

