/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.CautiousIncreaseAggressiveDecreaseConcurrencyLimiter;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.NeverThrowLimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;

final class StickyConcurrencyLimitedChannel
implements LimitedChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(StickyConcurrencyLimitedChannel.class);
    private final NeverThrowLimitedChannel delegate;
    private final CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter;
    private final String channelNameForLogging;

    @VisibleForTesting
    StickyConcurrencyLimitedChannel(LimitedChannel delegate, CautiousIncreaseAggressiveDecreaseConcurrencyLimiter limiter, String channelNameForLogging) {
        this.delegate = new NeverThrowLimitedChannel(delegate);
        this.limiter = limiter;
        this.channelNameForLogging = channelNameForLogging;
    }

    @Override
    public Optional<ListenableFuture<Response>> maybeExecute(Endpoint endpoint, Request request, LimitedChannel.LimitEnforcement limitEnforcement) {
        Optional<CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Permit> maybePermit = this.limiter.acquire(limitEnforcement);
        if (maybePermit.isPresent()) {
            CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Permit permit = maybePermit.get();
            this.logPermitAcquired();
            Optional<ListenableFuture<Response>> result = this.delegate.maybeExecute(endpoint, request, permit.isOnlyInFlight() ? LimitedChannel.LimitEnforcement.DANGEROUS_BYPASS_LIMITS : limitEnforcement);
            if (result.isPresent()) {
                DialogueFutures.addDirectCallback(result.get(), permit);
                return result;
            }
            maybePermit.get().dropped();
            return Optional.empty();
        }
        this.logPermitRefused();
        return Optional.empty();
    }

    static LimitedChannel create(LimitedChannel channel, String channelName) {
        return new StickyConcurrencyLimitedChannel(channel, new CautiousIncreaseAggressiveDecreaseConcurrencyLimiter(CautiousIncreaseAggressiveDecreaseConcurrencyLimiter.Behavior.STICKY), channelName);
    }

    private void logPermitAcquired() {
        if (log.isDebugEnabled()) {
            log.debug("Sending {}/{} on {}", SafeArg.of("inflight", this.limiter.getInflight()), SafeArg.of("max", this.limiter.getLimit()), SafeArg.of("channel", this.channelNameForLogging));
        }
    }

    private void logPermitRefused() {
        if (log.isDebugEnabled()) {
            log.debug("Limited {} on {}", SafeArg.of("max", this.limiter.getLimit()), SafeArg.of("channel", this.channelNameForLogging));
        }
    }

    public String toString() {
        return "StickyConcurrencyLimitedChannel{delegate=" + this.delegate + ", name=" + this.channelNameForLogging + "}";
    }
}

