/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import java.util.function.Consumer;
import java.util.function.Supplier;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.SettableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.core.LimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.QueueAttachments;
import shadow.palantir.driver.com.palantir.dialogue.core.QueuedChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.StickyAttachments;
import shadow.palantir.driver.com.palantir.dialogue.core.StickyConcurrencyLimitedChannel;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.concurrent.GuardedBy;
import shadow.palantir.driver.javax.annotation.concurrent.ThreadSafe;

final class StickyEndpointChannels2
implements Supplier<Channel> {
    private final Supplier<EndpointChannelFactory> delegate;

    StickyEndpointChannels2(Supplier<EndpointChannelFactory> endpointChannelFactory) {
        this.delegate = endpointChannelFactory;
    }

    @Override
    public Channel get() {
        return new StickyChannel2(this.delegate.get());
    }

    public String toString() {
        return "StickyEndpointChannels2{" + this.delegate + "}";
    }

    static Supplier<Channel> create(Config cf, LimitedChannel nodeSelectionChannel, EndpointChannelFactory delegate) {
        QueueOverrideSupplier queueOverrideSupplier = new QueueOverrideSupplier(cf, nodeSelectionChannel);
        return new StickyEndpointChannels2(new StickyEndpointChannels2EndpointFactorySupplier(queueOverrideSupplier, delegate));
    }

    private static final class StickyEndpointChannel
    implements EndpointChannel {
        private final StickyRouter stickyRouter;
        private final EndpointChannel delegate;

        StickyEndpointChannel(StickyRouter stickyRouter, EndpointChannel delegate) {
            this.stickyRouter = stickyRouter;
            this.delegate = delegate;
        }

        @Override
        public ListenableFuture<Response> execute(Request request) {
            return this.stickyRouter.execute(request, this.delegate);
        }

        public String toString() {
            return "StickyEndpointChannel{delegate=" + this.delegate + "}";
        }
    }

    @ThreadSafe
    private static final class StickyRouter {
        @Nullable
        private volatile Consumer<Request> stickyTarget;
        @Nullable
        @GuardedBy(value="this")
        private volatile ListenableFuture<Response> callInFlight;

        private StickyRouter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListenableFuture<Response> execute(Request request, EndpointChannel endpointChannel) {
            if (this.stickyTarget != null) {
                return StickyRouter.executeWithStickyTarget(this.stickyTarget, request, endpointChannel);
            }
            StickyRouter stickyRouter = this;
            synchronized (stickyRouter) {
                if (this.stickyTarget != null) {
                    return StickyRouter.executeWithStickyTarget(this.stickyTarget, request, endpointChannel);
                }
                ListenableFuture<Response> callInFlightSnapshot = this.callInFlight;
                if (callInFlightSnapshot == null) {
                    ListenableFuture<Response> executeWithStickyTokenResult = StickyRouter.executeWithStickyToken(request, endpointChannel);
                    final SettableFuture<Response> result = SettableFuture.create();
                    this.callInFlight = result;
                    DialogueFutures.addDirectCallback(executeWithStickyTokenResult, new FutureCallback<Response>(){

                        @Override
                        public void onSuccess(Response response) {
                            this.successfulCall(response);
                            if (!result.set(response)) {
                                response.close();
                            }
                        }

                        @Override
                        public void onFailure(Throwable throwable) {
                            this.failed();
                            result.setException(throwable);
                        }
                    });
                    DialogueFutures.addDirectListener(result, () -> {
                        if (result.isCancelled()) {
                            executeWithStickyTokenResult.cancel(false);
                        }
                    });
                    return result;
                }
                final SettableFuture<Response> result = SettableFuture.create();
                DialogueFutures.addDirectListener(callInFlightSnapshot, () -> {
                    if (!result.isDone()) {
                        ListenableFuture<Response> queuedRequestResponse = this.execute(request, endpointChannel);
                        DialogueFutures.addDirectCallback(queuedRequestResponse, new FutureCallback<Response>(){

                            @Override
                            public void onSuccess(Response response) {
                                if (!result.set(response)) {
                                    response.close();
                                }
                            }

                            @Override
                            public void onFailure(Throwable throwable) {
                                result.setException(throwable);
                            }
                        });
                        DialogueFutures.addDirectListener(result, () -> {
                            if (result.isCancelled()) {
                                queuedRequestResponse.cancel(false);
                            }
                        });
                    }
                });
                return result;
            }
        }

        private synchronized void successfulCall(Response response) {
            this.callInFlight = null;
            if (this.stickyTarget == null) {
                this.stickyTarget = StickyAttachments.copyStickyTarget(response);
            }
        }

        private synchronized void failed() {
            this.callInFlight = null;
        }

        private static ListenableFuture<Response> executeWithStickyToken(Request request, EndpointChannel endpointChannel) {
            StickyAttachments.requestStickyToken(request);
            return endpointChannel.execute(request);
        }

        private static ListenableFuture<Response> executeWithStickyTarget(Consumer<Request> stickyTarget, Request request, EndpointChannel endpointChannel) {
            stickyTarget.accept(request);
            return endpointChannel.execute(request);
        }
    }

    private static final class StickyChannel2
    implements EndpointChannelFactory,
    Channel {
        private final EndpointChannelFactory channelFactory;
        private final StickyRouter router = new StickyRouter();

        private StickyChannel2(EndpointChannelFactory channelFactory) {
            this.channelFactory = channelFactory;
        }

        @Override
        public EndpointChannel endpoint(Endpoint endpoint) {
            return new StickyEndpointChannel(this.router, this.channelFactory.endpoint(endpoint));
        }

        @Override
        public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
            return this.endpoint(endpoint).execute(request);
        }

        public String toString() {
            return "Sticky{" + this.channelFactory + "}";
        }
    }

    private static final class StickyEndpointChannels2EndpointFactorySupplier
    implements Supplier<EndpointChannelFactory> {
        private final Supplier<Channel> queueOverrideSupplier;
        private final EndpointChannelFactory delegate;

        StickyEndpointChannels2EndpointFactorySupplier(Supplier<Channel> queueOverrideSupplier, EndpointChannelFactory delegate) {
            this.queueOverrideSupplier = queueOverrideSupplier;
            this.delegate = delegate;
        }

        @Override
        public EndpointChannelFactory get() {
            Channel queueOverride = this.queueOverrideSupplier.get();
            return endpoint -> {
                EndpointChannel endpointChannel = this.delegate.endpoint(endpoint);
                return request -> {
                    QueueAttachments.setQueueOverride(request, queueOverride);
                    return endpointChannel.execute(request);
                };
            };
        }
    }

    private static final class QueueOverrideSupplier
    implements Supplier<Channel> {
        private final String channelName;
        private final int maxQueueSize;
        private final QueuedChannel.QueuedChannelInstrumentation queuedChannelInstrumentation;
        private final LimitedChannel nodeSelectionChannel;

        private QueueOverrideSupplier(Config cf, LimitedChannel nodeSelectionChannel) {
            this.channelName = cf.channelName();
            this.maxQueueSize = cf.maxQueueSize();
            this.queuedChannelInstrumentation = QueuedChannel.stickyInstrumentation(DialogueClientMetrics.of(cf.clientConf().taggedMetricRegistry()), this.channelName);
            this.nodeSelectionChannel = nodeSelectionChannel;
        }

        @Override
        public Channel get() {
            LimitedChannel stickyLimitedChannel = StickyConcurrencyLimitedChannel.create(this.nodeSelectionChannel, this.channelName);
            return QueuedChannel.createForSticky(this.channelName, this.maxQueueSize, this.queuedChannelInstrumentation, stickyLimitedChannel);
        }
    }
}

