/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.Preconditions;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Optional;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.dialogue.core.MeshMode;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class TargetUri
implements Comparable<TargetUri> {
    private final String uri;
    private final Optional<InetAddress> resolvedAddress;

    private TargetUri(String uri, Optional<InetAddress> resolvedAddress) {
        this.uri = uri;
        this.resolvedAddress = resolvedAddress;
    }

    public String uri() {
        return this.uri;
    }

    public Optional<InetAddress> resolvedAddress() {
        return this.resolvedAddress;
    }

    @Override
    public int compareTo(TargetUri other) {
        int result = this.uri.compareTo(other.uri);
        if (result != 0) {
            return result;
        }
        result = Arrays.compare(this.resolvedAddress.map(InetAddress::getAddress).orElse(null), other.resolvedAddress.map(InetAddress::getAddress).orElse(null));
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        return "TargetUri{uri='" + this.uri + "', resolvedAddress=" + this.resolvedAddress + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TargetUri targetUri = (TargetUri)other;
        return this.uri.equals(targetUri.uri) && this.resolvedAddress.equals(targetUri.resolvedAddress);
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = 31 * result + this.resolvedAddress.hashCode();
        return result;
    }

    public static TargetUri of(String uri) {
        return TargetUri.builder().uri(uri).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String uri;
        @Nullable
        private InetAddress resolvedAddress;

        private Builder() {
        }

        public Builder uri(String value) {
            this.uri = MeshMode.stripMeshPrefix(Preconditions.checkNotNull(value, "uri"));
            return this;
        }

        public Builder resolvedAddress(InetAddress value) {
            this.resolvedAddress = Preconditions.checkNotNull(value, "resolvedAddress");
            return this;
        }

        public Builder resolvedAddress(Optional<InetAddress> value) {
            this.resolvedAddress = Preconditions.checkNotNull(value, "resolvedAddress").orElse(null);
            return this;
        }

        @CheckReturnValue
        public TargetUri build() {
            return new TargetUri(Preconditions.checkNotNull(this.uri, "uri"), Optional.ofNullable(this.resolvedAddress));
        }
    }
}

