/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.RateLimiter;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.ClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.Responses;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class TimingEndpointChannel
implements EndpointChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(TimingEndpointChannel.class);
    private static final RateLimiter unknownThrowableLoggingRateLimiter = RateLimiter.create(1.0);
    private final EndpointChannel delegate;
    private final Supplier<Timer> successTimer;
    private final Supplier<Timer> failureTimer;
    private final Ticker ticker;

    TimingEndpointChannel(EndpointChannel delegate, Ticker ticker, TaggedMetricRegistry taggedMetrics, String channelName, Endpoint endpoint) {
        this.delegate = delegate;
        this.ticker = ticker;
        ClientMetrics metrics = ClientMetrics.of(taggedMetrics);
        this.successTimer = Suppliers.memoize(() -> metrics.response().channelName(channelName).serviceName(endpoint.serviceName()).endpoint(endpoint.endpointName()).status("success").build());
        this.failureTimer = Suppliers.memoize(() -> metrics.response().channelName(channelName).serviceName(endpoint.serviceName()).endpoint(endpoint.endpointName()).status("failure").build());
    }

    static EndpointChannel create(Config cf, EndpointChannel delegate, Endpoint endpoint) {
        return new TimingEndpointChannel(delegate, cf.ticker(), cf.clientConf().taggedMetricRegistry(), cf.channelName(), endpoint);
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        final long beforeNanos = this.ticker.read();
        ListenableFuture<Response> response = this.delegate.execute(request);
        return DialogueFutures.addDirectCallback(response, new FutureCallback<Response>(){

            @Override
            public void onSuccess(Response response) {
                if (Responses.isSuccess(response)) {
                    this.updateTimer(TimingEndpointChannel.this.successTimer);
                } else if (Responses.isQosStatus(response) || Responses.isInternalServerError(response)) {
                    this.updateTimer(TimingEndpointChannel.this.failureTimer);
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                if (throwable instanceof IOException) {
                    this.updateTimer(TimingEndpointChannel.this.failureTimer);
                } else if (unknownThrowableLoggingRateLimiter.tryAcquire()) {
                    log.info("Unknown failure", SafeArg.of("exceptionClass", throwable.getClass().getName()));
                }
            }

            private void updateTimer(Supplier<Timer> timer) {
                timer.get().update(TimingEndpointChannel.this.ticker.read() - beforeNanos, TimeUnit.NANOSECONDS);
            }
        });
    }

    public String toString() {
        return "TimingEndpointChannel{" + this.delegate + "}";
    }
}

