/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueTracing;
import shadow.palantir.driver.com.palantir.dialogue.core.NeverThrowChannel;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.com.palantir.tracing.CloseableSpan;
import shadow.palantir.driver.com.palantir.tracing.DetachedSpan;
import shadow.palantir.driver.com.palantir.tracing.TagTranslator;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.com.palantir.tracing.Tracers;
import shadow.palantir.driver.com.palantir.tracing.TracingHeadersEnrichingFunction;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;

final class TraceEnrichingChannel
implements Channel {
    private static final String OPERATION = "Dialogue-http-request";
    private final NeverThrowChannel delegate;
    private final TagTranslator<Response> responseTranslator;
    private final TagTranslator<Throwable> throwableTranslator;

    TraceEnrichingChannel(Channel delegate, ImmutableMap<String, String> tags) {
        this.delegate = new NeverThrowChannel(delegate);
        this.responseTranslator = DialogueTracing.responseTranslator(tags);
        this.throwableTranslator = DialogueTracing.failureTranslator(tags);
    }

    @Override
    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        if (Tracer.hasUnobservableTrace()) {
            return this.executeInternal(endpoint, request);
        }
        return this.executeSampled(endpoint, request);
    }

    private ListenableFuture<Response> executeSampled(Endpoint endpoint, Request request) {
        final DetachedSpan span = DetachedSpan.start(OPERATION, SpanType.CLIENT_OUTGOING);
        try (CloseableSpan ignored = span.attach();){
            ListenableFuture<Response> future = this.executeInternal(endpoint, request);
            ListenableFuture<Response> listenableFuture = DialogueFutures.addDirectCallback(future, new FutureCallback<Response>(){

                @Override
                public void onSuccess(Response response) {
                    span.complete(TraceEnrichingChannel.this.responseTranslator, response);
                }

                @Override
                public void onFailure(Throwable throwable) {
                    span.complete(TraceEnrichingChannel.this.throwableTranslator, throwable);
                }
            });
            return listenableFuture;
        }
    }

    private ListenableFuture<Response> executeInternal(Endpoint endpoint, Request request) {
        Request.Builder requestBuilder = Request.builder().from(request);
        Tracers.addTracingHeaders(requestBuilder, RequestTracingHeadersEnrichingFunction.INSTANCE);
        return this.delegate.execute(endpoint, requestBuilder.build());
    }

    public String toString() {
        return "TracedRequestChannel{" + this.delegate + "}";
    }

    private static enum RequestTracingHeadersEnrichingFunction implements TracingHeadersEnrichingFunction<Request.Builder>
    {
        INSTANCE;


        @Override
        public void addHeader(String headerName, String headerValue, Request.Builder state) {
            state.putHeaderParams(headerName, headerValue);
        }
    }
}

