/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.core.Config;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueTracing;
import shadow.palantir.driver.com.palantir.dialogue.core.MeshMode;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.com.palantir.tracing.CloseableSpan;
import shadow.palantir.driver.com.palantir.tracing.DetachedSpan;
import shadow.palantir.driver.com.palantir.tracing.TagTranslator;
import shadow.palantir.driver.com.palantir.tracing.Tracer;

final class TracedChannel
implements EndpointChannel {
    private final EndpointChannel delegate;
    private final String operationName;
    private final TagTranslator<Response> responseTranslator;
    private final TagTranslator<Throwable> throwableTranslator;

    private TracedChannel(EndpointChannel delegate, String operationName, ImmutableMap<String, String> tags) {
        this.delegate = delegate;
        this.operationName = operationName;
        this.responseTranslator = DialogueTracing.responseTranslator(tags);
        this.throwableTranslator = DialogueTracing.failureTranslator(tags);
    }

    static EndpointChannel create(Config cf, EndpointChannel delegate, Endpoint endpoint) {
        String operationName = "Dialogue: request " + endpoint.serviceName() + "#" + endpoint.endpointName() + TracedChannel.meshSuffix(cf.mesh());
        return new TracedChannel(delegate, operationName, TracedChannel.tracingTags(cf, endpoint));
    }

    private static String meshSuffix(MeshMode meshMode) {
        return meshMode == MeshMode.USE_EXTERNAL_MESH ? " (Mesh)" : "";
    }

    private static ImmutableMap<String, String> tracingTags(Config cf, Endpoint endpoint) {
        ImmutableMap<String, String> endpointTags = DialogueTracing.tracingTags(endpoint);
        ImmutableMap<String, String> configTags = DialogueTracing.tracingTags(cf);
        return ImmutableMap.builderWithExpectedSize(endpointTags.size() + configTags.size()).putAll(endpointTags).putAll(configTags).buildOrThrow();
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        if (Tracer.hasUnobservableTrace()) {
            return this.delegate.execute(request);
        }
        return this.executeSampled(request);
    }

    private ListenableFuture<Response> executeSampled(Request request) {
        final DetachedSpan span = DetachedSpan.start(this.operationName);
        CloseableSpan ignored = span.attach();
        try {
            ListenableFuture<Response> listenableFuture = DialogueFutures.addDirectCallback(this.delegate.execute(request), new FutureCallback<Response>(){

                @Override
                public void onSuccess(Response response) {
                    span.complete(TracedChannel.this.responseTranslator, response);
                }

                @Override
                public void onFailure(Throwable throwable) {
                    span.complete(TracedChannel.this.throwableTranslator, throwable);
                }
            });
            if (ignored != null) {
                ignored.close();
            }
            return listenableFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                span.complete(this.throwableTranslator, t);
                throw t;
            }
        }
    }

    public String toString() {
        return "TracedChannel{operationName=" + this.operationName + ", delegate=" + this.delegate + "}";
    }
}

