/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.core;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.List;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgents;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.EndpointChannel;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.javax.annotation.Nullable;

final class UserAgentEndpointChannel
implements EndpointChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(UserAgentEndpointChannel.class);
    static final UserAgent.Agent DIALOGUE_AGENT = UserAgentEndpointChannel.extractDialogueAgent();
    private final EndpointChannel delegate;
    private final String userAgent;

    private UserAgentEndpointChannel(EndpointChannel delegate, String userAgent) {
        this.delegate = delegate;
        this.userAgent = userAgent;
    }

    static EndpointChannel create(EndpointChannel delegate, Endpoint endpoint, UserAgent baseAgent) {
        String userAgent = UserAgents.format(UserAgentEndpointChannel.augmentUserAgent(baseAgent, endpoint));
        return new UserAgentEndpointChannel(delegate, userAgent);
    }

    @Override
    public ListenableFuture<Response> execute(Request request) {
        Request newRequest = Request.builder().from(request).putHeaderParams("user-agent", this.userAgent).build();
        return this.delegate.execute(newRequest);
    }

    private static UserAgent augmentUserAgent(UserAgent baseAgent, Endpoint endpoint) {
        UserAgent.Agent endpointAgent = UserAgentEndpointChannel.getEndpointAgent(endpoint);
        try {
            List<UserAgent.Agent> informationalAgents = endpointAgent == null ? List.of(DIALOGUE_AGENT) : List.of(endpointAgent, DIALOGUE_AGENT);
            return UserAgent.of(baseAgent, informationalAgents);
        }
        catch (RuntimeException e) {
            log.error("Could not construct user agent", e);
            return baseAgent;
        }
    }

    @Nullable
    private static UserAgent.Agent getEndpointAgent(Endpoint endpoint) {
        String endpointService = endpoint.serviceName();
        String endpointVersion = UserAgentEndpointChannel.getEndpointVersion(endpoint);
        try {
            return UserAgent.Agent.of(endpoint.serviceName(), endpointVersion);
        }
        catch (IllegalArgumentException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to construct UserAgent for service {} version {}. This information will not be included", SafeArg.of("service", endpointService), SafeArg.of("version", endpointVersion), e);
            }
            return null;
        }
    }

    private static String getEndpointVersion(Endpoint endpoint) {
        String jarVersion;
        String endpointVersion = endpoint.version();
        if ("0.0.0".equals(endpointVersion) && (jarVersion = endpoint.getClass().getPackage().getImplementationVersion()) != null) {
            return jarVersion;
        }
        return endpointVersion;
    }

    private static UserAgent.Agent extractDialogueAgent() {
        String version = UserAgentEndpointChannel.dialogueVersion();
        return UserAgent.Agent.of("dialogue", version);
    }

    static String dialogueVersion() {
        String maybeDialogueVersion = Channel.class.getPackage().getImplementationVersion();
        return maybeDialogueVersion != null ? maybeDialogueVersion : "0.0.0";
    }

    public String toString() {
        return "UserAgentEndpointChannel{userAgent='" + this.userAgent + "', proceed=" + this.delegate + "}";
    }
}

