/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.futures;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import shadow.palantir.driver.com.google.common.util.concurrent.AsyncFunction;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;

final class DialogueDirectAsyncCatchingFuture<T>
implements ListenableFuture<T>,
Runnable {
    private volatile ListenableFuture<T> currentFuture;
    private final ListenableFuture<T> output;

    DialogueDirectAsyncCatchingFuture(ListenableFuture<T> input, AsyncFunction<? super Throwable, T> function) {
        this.currentFuture = input;
        this.output = Futures.catchingAsync(input, Throwable.class, throwable -> {
            if (input.isCancelled()) {
                return Futures.immediateCancelledFuture();
            }
            ListenableFuture future = function.apply((Throwable)throwable);
            this.currentFuture = future;
            return future;
        }, DialogueFutures.safeDirectExecutor());
        this.output.addListener(this, DialogueFutures.safeDirectExecutor());
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.output.addListener(listener, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        ListenableFuture<T> snapshot = this.currentFuture;
        return snapshot.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.output.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.output.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return (T)this.output.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.output.get(timeout, unit);
    }

    @Override
    public void run() {
        this.currentFuture = this.output;
    }
}

