/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.futures;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import shadow.palantir.driver.com.google.common.util.concurrent.AsyncFunction;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;

final class DialogueDirectAsyncTransformationFuture<I, O>
implements ListenableFuture<O>,
Runnable {
    private volatile ListenableFuture<?> currentFuture;
    private final ListenableFuture<O> output;

    DialogueDirectAsyncTransformationFuture(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        this.currentFuture = input;
        this.output = Futures.transformAsync(input, result -> {
            ListenableFuture future = function.apply(result);
            this.currentFuture = future;
            return future;
        }, DialogueFutures.safeDirectExecutor());
        this.output.addListener(this, DialogueFutures.safeDirectExecutor());
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.output.addListener(listener, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        ListenableFuture<?> snapshot = this.currentFuture;
        return snapshot.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        ListenableFuture<?> snapshot = this.currentFuture;
        return snapshot.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.output.isDone();
    }

    @Override
    public O get() throws InterruptedException, ExecutionException {
        return (O)this.output.get();
    }

    @Override
    public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (O)this.output.get(timeout, unit);
    }

    @Override
    public void run() {
        this.currentFuture = this.output;
    }
}

