/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.futures;

import com.palantir.logsafe.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.SettableFuture;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueFutures;
import shadow.palantir.driver.javax.annotation.Nullable;

final class DialogueDirectTransformationFuture<I, O>
implements ListenableFuture<O>,
FutureCallback<I> {
    @Nullable
    private ListenableFuture<I> input;
    @Nullable
    private Function<? super I, ? extends O> function;
    private final SettableFuture<O> output;

    DialogueDirectTransformationFuture(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        this.input = input;
        this.function = function;
        this.output = SettableFuture.create();
        Futures.addCallback(input, this, DialogueFutures.safeDirectExecutor());
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.output.addListener(listener, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        ListenableFuture<I> inputSnapshot = this.input;
        if (inputSnapshot != null) {
            return inputSnapshot.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        ListenableFuture<I> inputSnapshot = this.input;
        if (inputSnapshot != null) {
            return inputSnapshot.isCancelled();
        }
        return this.output.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.output.isDone();
    }

    @Override
    public O get() throws InterruptedException, ExecutionException {
        return (O)this.output.get();
    }

    @Override
    public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (O)this.output.get(timeout, unit);
    }

    @Override
    public void onSuccess(I result) {
        try {
            O transformed = Preconditions.checkNotNull(this.function, "transformation function").apply(result);
            this.output.set(transformed);
        }
        catch (Throwable t) {
            this.output.setException(t);
        }
        this.input = null;
        this.function = null;
    }

    @Override
    public void onFailure(Throwable throwable) {
        ListenableFuture<I> inputSnapshot = this.input;
        if (inputSnapshot != null && inputSnapshot.isCancelled()) {
            this.output.cancel(false);
        } else {
            this.output.setException(throwable);
        }
        this.input = null;
        this.function = null;
    }
}

