/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.futures;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import shadow.palantir.driver.com.google.common.util.concurrent.AsyncFunction;
import shadow.palantir.driver.com.google.common.util.concurrent.FutureCallback;
import shadow.palantir.driver.com.google.common.util.concurrent.Futures;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueDirectAsyncCatchingFuture;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueDirectAsyncTransformationFuture;
import shadow.palantir.driver.com.palantir.dialogue.futures.DialogueDirectTransformationFuture;
import shadow.palantir.driver.com.palantir.dialogue.futures.SafeDirectExecutor;

public final class DialogueFutures {
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        return new DialogueDirectTransformationFuture<I, O>(input, function);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        return new DialogueDirectAsyncTransformationFuture<I, O>(input, function);
    }

    public static <T> ListenableFuture<T> catchingAllAsync(ListenableFuture<T> input, AsyncFunction<Throwable, T> function) {
        return new DialogueDirectAsyncCatchingFuture<T>(input, function);
    }

    @CanIgnoreReturnValue
    public static <T> ListenableFuture<T> addDirectCallback(ListenableFuture<T> future, FutureCallback<T> callback) {
        Futures.addCallback(future, callback, DialogueFutures.safeDirectExecutor());
        return future;
    }

    @CanIgnoreReturnValue
    public static <T> ListenableFuture<T> addDirectListener(ListenableFuture<T> future, Runnable listener) {
        future.addListener(listener, DialogueFutures.safeDirectExecutor());
        return future;
    }

    public static Executor safeDirectExecutor() {
        return SafeDirectExecutor.INSTANCE;
    }

    public static <T> FutureCallback<T> onSuccess(final Consumer<T> onSuccess) {
        return new FutureCallback<T>(){

            @Override
            public void onSuccess(T result) {
                onSuccess.accept(result);
            }

            @Override
            public void onFailure(Throwable _throwable) {
            }
        };
    }

    private DialogueFutures() {
    }
}

