/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.exceptions.SafeExceptions;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.collect.ListMultimap;
import shadow.palantir.driver.com.google.common.collect.Multimap;
import shadow.palantir.driver.com.google.common.collect.MultimapBuilder;
import shadow.palantir.driver.com.google.common.collect.Multimaps;
import shadow.palantir.driver.com.google.common.io.ByteStreams;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.HttpMethod;
import shadow.palantir.driver.com.palantir.dialogue.Request;
import shadow.palantir.driver.com.palantir.dialogue.RequestBody;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.ResponseAttachments;
import shadow.palantir.driver.com.palantir.dialogue.blocking.BlockingChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.BaseUrl;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ApacheHttpClientChannels;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueRoutePlanner;
import shadow.palantir.driver.com.palantir.dialogue.hc5.EmptyHttpEntity;
import shadow.palantir.driver.com.palantir.dialogue.hc5.HttpClientExecRuntimeAttributeInterceptor;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ResponseLeakDetector;
import shadow.palantir.driver.com.palantir.dialogue.hc5.SafeConnectTimeoutException;
import shadow.palantir.driver.com.palantir.dialogue.hc5.SafeSocketTimeoutException;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.hc.client5.http.ConnectTimeoutException;
import shadow.palantir.driver.org.apache.hc.client5.http.classic.ExecRuntime;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import shadow.palantir.driver.org.apache.hc.client5.http.protocol.HttpClientContext;
import shadow.palantir.driver.org.apache.hc.core5.function.Supplier;
import shadow.palantir.driver.org.apache.hc.core5.http.Header;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpEntity;
import shadow.palantir.driver.org.apache.hc.core5.http.NameValuePair;
import shadow.palantir.driver.org.apache.hc.core5.http.NoHttpResponseException;
import shadow.palantir.driver.org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import shadow.palantir.driver.org.apache.hc.core5.http.message.BasicHeader;

final class ApacheHttpClientBlockingChannel
implements BlockingChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(ApacheHttpClientBlockingChannel.class);
    private static final int REMAINING_CONTENT_CONNECTION_DISCARD_THRESHOLD = 65536;
    private final ApacheHttpClientChannels.CloseableClient client;
    private final BaseUrl baseUrl;
    private final Optional<InetAddress> resolvedHost;
    private final ResponseLeakDetector responseLeakDetector;
    private final OptionalInt uriIndexForInstrumentation;

    ApacheHttpClientBlockingChannel(ApacheHttpClientChannels.CloseableClient client, URL baseUrl, Optional<InetAddress> resolvedHost, ResponseLeakDetector responseLeakDetector, OptionalInt uriIndexForInstrumentation) {
        this.client = client;
        this.baseUrl = BaseUrl.of(baseUrl);
        this.resolvedHost = resolvedHost;
        this.responseLeakDetector = responseLeakDetector;
        this.uriIndexForInstrumentation = uriIndexForInstrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute(Endpoint endpoint, Request request) throws IOException {
        Response response;
        block12: {
            URL target = this.baseUrl.render(endpoint, request);
            ClassicRequestBuilder builder = ClassicRequestBuilder.create(endpoint.httpMethod().name()).setUri(target.toString());
            request.headerParams().forEach(builder::addHeader);
            if (request.body().isPresent()) {
                Preconditions.checkArgument(endpoint.httpMethod() != HttpMethod.GET, "GET endpoints must not have a request body");
                Preconditions.checkArgument(endpoint.httpMethod() != HttpMethod.HEAD, "HEAD endpoints must not have a request body");
                Preconditions.checkArgument(endpoint.httpMethod() != HttpMethod.OPTIONS, "OPTIONS endpoints must not have a request body");
                RequestBody body = request.body().get();
                ApacheHttpClientBlockingChannel.setBody(builder, body);
            } else if (ApacheHttpClientBlockingChannel.requiresEmptyBody(endpoint)) {
                builder.setEntity(EmptyHttpEntity.INSTANCE);
            }
            long startTime = System.nanoTime();
            HttpClientContext context = HttpClientContext.create();
            this.resolvedHost.ifPresent(inetAddress -> DialogueRoutePlanner.set(context, inetAddress));
            CloseableHttpResponse httpClientResponse = this.client.apacheClient().execute(builder.build(), context);
            boolean close = true;
            try {
                HttpClientResponse dialogueResponse = new HttpClientResponse(this.client, httpClientResponse, context);
                Response leakDetectingResponse = this.responseLeakDetector.wrap(dialogueResponse, endpoint);
                close = false;
                response = leakDetectingResponse;
                if (!close) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (close) {
                        httpClientResponse.close();
                    }
                    throw throwable;
                }
                catch (ConnectTimeoutException e) {
                    throw new SafeConnectTimeoutException(e, this.failureDiagnosticArgs(endpoint, request, startTime));
                }
                catch (NoHttpResponseException e) {
                    long durationNanos = System.nanoTime() - startTime;
                    Arg<?>[] diagnosticArgs = this.failureDiagnosticArgs(endpoint, request, startTime);
                    if (durationNanos < TimeUnit.SECONDS.toNanos(5L)) {
                        e.addSuppressed(new Diagnostic(diagnosticArgs));
                        throw e;
                    }
                    throw new SafeSocketTimeoutException("Received a NoHttpResponseException", e, diagnosticArgs);
                }
                catch (Throwable t) {
                    t.addSuppressed(new Diagnostic(this.failureDiagnosticArgs(endpoint, request, startTime)));
                    throw t;
                }
            }
            httpClientResponse.close();
        }
        return response;
    }

    private Arg<?>[] failureDiagnosticArgs(Endpoint endpoint, Request request, long startTimeNanos) {
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNanos);
        return new Arg[]{SafeArg.of("durationMillis", durationMillis), SafeArg.of("connectTimeout", this.client.clientConfiguration().connectTimeout()), SafeArg.of("socketTimeout", this.client.clientConfiguration().readTimeout()), SafeArg.of("clientName", this.client.name()), SafeArg.of("serviceName", endpoint.serviceName()), SafeArg.of("endpointName", endpoint.endpointName()), SafeArg.of("requestTraceId", request.headerParams().get((Object)"X-B3-TraceId")), SafeArg.of("requestSpanId", request.headerParams().get((Object)"X-B3-SpanId")), SafeArg.of("hostIndex", this.uriIndexForInstrumentation)};
    }

    private static boolean requiresEmptyBody(Endpoint endpoint) {
        HttpMethod method = endpoint.httpMethod();
        return method == HttpMethod.POST || method == HttpMethod.PUT;
    }

    private static void setBody(ClassicRequestBuilder builder, RequestBody body) {
        builder.setEntity(new RequestBodyEntity(body, ApacheHttpClientBlockingChannel.contentLength(body, builder)));
    }

    private static OptionalLong contentLength(RequestBody requestBody, ClassicRequestBuilder builder) {
        long requestBodyContentLength;
        long headerContentLengthValue;
        Header contentLengthHeader = builder.getFirstHeader("Content-Length");
        OptionalLong headerContentLength = OptionalLong.empty();
        if (contentLengthHeader != null) {
            builder.removeHeaders("Content-Length");
            String contentLengthValue = contentLengthHeader.getValue();
            try {
                headerContentLength = OptionalLong.of(Long.parseLong(contentLengthValue));
            }
            catch (NumberFormatException nfe) {
                log.warn("Failed to parse content-length value '{}'", SafeArg.of("Content-Length", contentLengthValue), (Throwable)nfe);
            }
        }
        if (headerContentLength.isPresent() && requestBody.contentLength().isPresent() && (headerContentLengthValue = headerContentLength.getAsLong()) != (requestBodyContentLength = requestBody.contentLength().getAsLong())) {
            log.warn("Content lengths do not match", SafeArg.of("Content-Length", headerContentLengthValue), SafeArg.of("requestBodyContentLength", requestBodyContentLength));
        }
        if (headerContentLength.isPresent()) {
            return headerContentLength;
        }
        return requestBody.contentLength();
    }

    private static boolean hasSubstantialRemainingData(CloseableHttpResponse response) {
        try {
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                return false;
            }
            InputStream stream = entity.getContent();
            if (stream.read() == -1) {
                return false;
            }
            return 65536L == ByteStreams.exhaust(ByteStreams.limit(stream, 65536L));
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static final class DialogueStreamClosedException
    extends IOException
    implements SafeLoggable {
        private static final String MESSAGE = "Response has already been closed";

        DialogueStreamClosedException() {
            super(MESSAGE);
        }

        @Override
        public String getLogMessage() {
            return MESSAGE;
        }

        @Override
        public List<Arg<?>> getArgs() {
            return ImmutableList.of();
        }
    }

    private static final class ResponseInputStream
    extends FilterInputStream {
        private final HttpClientResponse response;

        ResponseInputStream(InputStream stream, HttpClientResponse response) {
            super(stream);
            this.response = response;
        }

        @Override
        public int read() throws IOException {
            this.checkOpen();
            return super.read();
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            this.checkOpen();
            return super.read(buffer);
        }

        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            this.checkOpen();
            return super.read(buffer, off, len);
        }

        @Override
        public long skip(long num) throws IOException {
            this.checkOpen();
            return super.skip(num);
        }

        @Override
        public void close() {
            if (this.response.isOpen()) {
                this.response.close();
            }
        }

        private void checkOpen() throws IOException {
            if (!this.response.isOpen()) {
                throw new DialogueStreamClosedException();
            }
        }

        public String toString() {
            return "ResponseInputStream{" + this.in + "}";
        }
    }

    static final class ModulatingOutputStream
    extends FilterOutputStream {
        private static final int BLOCK_SIZE = 16384;

        ModulatingOutputStream(OutputStream delegate) {
            super(delegate);
        }

        @Override
        public void write(byte[] buffer, int off, int len) throws IOException {
            int toWrite;
            Objects.checkFromIndexSize(off, len, buffer.length);
            int currentOffset = off;
            for (int remaining = len; remaining > 0; remaining -= toWrite) {
                toWrite = Math.min(remaining, 16384);
                this.out.write(buffer, currentOffset, toWrite);
                currentOffset += toWrite;
            }
        }

        @Override
        public void write(int value) throws IOException {
            this.out.write(value);
        }
    }

    private static final class RequestBodyEntity
    implements HttpEntity {
        private final RequestBody requestBody;
        private final Header contentType;
        private final OptionalLong contentLength;

        RequestBodyEntity(RequestBody requestBody, OptionalLong contentLength) {
            this.requestBody = requestBody;
            this.contentType = new BasicHeader("Content-Type", requestBody.contentType());
            this.contentLength = contentLength;
        }

        @Override
        public boolean isRepeatable() {
            return this.requestBody.repeatable();
        }

        @Override
        public boolean isChunked() {
            return !this.contentLength.isPresent();
        }

        @Override
        public Set<String> getTrailerNames() {
            return Collections.emptySet();
        }

        @Override
        public long getContentLength() {
            return this.contentLength.orElse(-1L);
        }

        @Override
        public String getContentType() {
            return this.contentType.getValue();
        }

        @Override
        @Nullable
        public String getContentEncoding() {
            return null;
        }

        @Override
        public InputStream getContent() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("getContent is not supported, writeTo should be used");
        }

        @Override
        public void writeTo(OutputStream outStream) throws IOException {
            this.requestBody.writeTo(new ModulatingOutputStream(outStream));
        }

        @Override
        public boolean isStreaming() {
            return false;
        }

        @Override
        @Nullable
        public Supplier<List<? extends Header>> getTrailers() {
            return null;
        }

        public String toString() {
            return "RequestBodyEntity{requestBody=" + this.requestBody + "}";
        }

        @Override
        public void close() {
        }
    }

    private static final class HttpClientResponse
    implements Response {
        private final CloseableHttpResponse response;
        private final HttpClientContext context;
        private final ResponseAttachments attachments = ResponseAttachments.create();
        @Nullable
        private ApacheHttpClientChannels.CloseableClient client;
        @Nullable
        private ListMultimap<String, String> headers;
        @Nullable
        private InputStream responseBody;

        HttpClientResponse(ApacheHttpClientChannels.CloseableClient client, CloseableHttpResponse response, HttpClientContext context) {
            this.client = client;
            this.response = response;
            this.context = context;
        }

        @Override
        public InputStream body() {
            InputStream snapshot = this.responseBody;
            if (snapshot == null) {
                this.responseBody = snapshot = this.createResponseBody();
            }
            return snapshot;
        }

        private InputStream createResponseBody() {
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                try {
                    return new ResponseInputStream(entity.getContent(), this);
                }
                catch (IOException e) {
                    throw new SafeRuntimeException("Failed to get response stream", (Throwable)e, new Arg[0]);
                }
            }
            return new ByteArrayInputStream(new byte[0]);
        }

        @Override
        public int code() {
            return this.response.getCode();
        }

        @Override
        public ListMultimap<String, String> headers() {
            if (this.headers == null) {
                Multimap tmpHeaders = MultimapBuilder.treeKeys(String.CASE_INSENSITIVE_ORDER).arrayListValues().build();
                Iterator<Header> headerIterator = this.response.headerIterator();
                while (headerIterator.hasNext()) {
                    Header header = headerIterator.next();
                    String value = header.getValue();
                    if (value == null) continue;
                    tmpHeaders.put(header.getName(), value);
                }
                this.headers = Multimaps.unmodifiableListMultimap(tmpHeaders);
            }
            return this.headers;
        }

        @Override
        public Optional<String> getFirstHeader(String header) {
            return Optional.ofNullable(this.response.getFirstHeader(header)).map(NameValuePair::getValue);
        }

        @Override
        public ResponseAttachments attachments() {
            return this.attachments;
        }

        @Override
        public void close() {
            ApacheHttpClientChannels.CloseableClient clientSnapshot = this.client;
            this.client = null;
            if (clientSnapshot != null) {
                try {
                    ExecRuntime runtime;
                    if (ApacheHttpClientBlockingChannel.hasSubstantialRemainingData(this.response) && (runtime = HttpClientExecRuntimeAttributeInterceptor.get(this.context)) != null) {
                        runtime.discardEndpoint();
                        DialogueClientMetrics.of(clientSnapshot.clientConfiguration().taggedMetricRegistry()).connectionClosedPartiallyConsumedResponse(clientSnapshot.name()).mark();
                        return;
                    }
                    this.response.close();
                }
                catch (IOException | RuntimeException e) {
                    log.warn("Failed to close response", e);
                }
            }
        }

        boolean isOpen() {
            return this.client != null;
        }

        public String toString() {
            return "HttpClientResponse{response=" + this.response + ", client=" + this.client + "}";
        }
    }

    private static final class Diagnostic
    extends RuntimeException
    implements SafeLoggable {
        private static final String SAFE_MESSAGE = "Client Failure Diagnostic Information";
        private final List<Arg<?>> args;

        Diagnostic(Arg<?>[] args) {
            super(SafeExceptions.renderMessage(SAFE_MESSAGE, args));
            this.args = Collections.unmodifiableList(Arrays.asList(args));
        }

        @Override
        public String getLogMessage() {
            return SAFE_MESSAGE;
        }

        @Override
        public List<Arg<?>> getArgs() {
            return this.args;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

