/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.net.ssl.SSLSocketFactory;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.google.common.io.Closer;
import shadow.palantir.driver.com.google.common.net.HostAndPort;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.BasicCredentials;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.CipherSuites;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.ClientConfiguration;
import shadow.palantir.driver.com.palantir.dialogue.Channel;
import shadow.palantir.driver.com.palantir.dialogue.blocking.BlockingChannelAdapter;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueChannel;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueChannelFactory;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueDnsResolver;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueInternalWeakReducingGauge;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ApacheHttpClientBlockingChannel;
import shadow.palantir.driver.com.palantir.dialogue.hc5.CleanerSupport;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ConnectInstrumentation;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientPoolMetrics;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueRoutePlanner;
import shadow.palantir.driver.com.palantir.dialogue.hc5.HttpClientExecRuntimeAttributeInterceptor;
import shadow.palantir.driver.com.palantir.dialogue.hc5.InactivityValidationAwareConnectionKeepAliveStrategy;
import shadow.palantir.driver.com.palantir.dialogue.hc5.InstrumentedDnsResolver;
import shadow.palantir.driver.com.palantir.dialogue.hc5.InstrumentedHostnameVerifier;
import shadow.palantir.driver.com.palantir.dialogue.hc5.InstrumentedManagedHttpConnectionFactory;
import shadow.palantir.driver.com.palantir.dialogue.hc5.InstrumentedPlainConnectionSocketFactory;
import shadow.palantir.driver.com.palantir.dialogue.hc5.InstrumentedPoolingHttpClientConnectionManager;
import shadow.palantir.driver.com.palantir.dialogue.hc5.InstrumentedSslConnectionSocketFactory;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ResponseLeakDetector;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ScheduledIdleConnectionEvictor;
import shadow.palantir.driver.com.palantir.dialogue.hc5.TlsProtocols;
import shadow.palantir.driver.com.palantir.tritium.metrics.MetricRegistries;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.hc.client5.http.AuthenticationStrategy;
import shadow.palantir.driver.org.apache.hc.client5.http.SystemDefaultDnsResolver;
import shadow.palantir.driver.org.apache.hc.client5.http.auth.AuthChallenge;
import shadow.palantir.driver.org.apache.hc.client5.http.auth.AuthScheme;
import shadow.palantir.driver.org.apache.hc.client5.http.auth.AuthScope;
import shadow.palantir.driver.org.apache.hc.client5.http.auth.ChallengeType;
import shadow.palantir.driver.org.apache.hc.client5.http.auth.Credentials;
import shadow.palantir.driver.org.apache.hc.client5.http.auth.CredentialsProvider;
import shadow.palantir.driver.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import shadow.palantir.driver.org.apache.hc.client5.http.config.RequestConfig;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.classic.HttpClients;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import shadow.palantir.driver.org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import shadow.palantir.driver.org.apache.hc.core5.http.URIScheme;
import shadow.palantir.driver.org.apache.hc.core5.http.config.RegistryBuilder;
import shadow.palantir.driver.org.apache.hc.core5.http.io.SocketConfig;
import shadow.palantir.driver.org.apache.hc.core5.http.protocol.HttpContext;
import shadow.palantir.driver.org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import shadow.palantir.driver.org.apache.hc.core5.pool.PoolReusePolicy;
import shadow.palantir.driver.org.apache.hc.core5.pool.PoolStats;
import shadow.palantir.driver.org.apache.hc.core5.util.TimeValue;
import shadow.palantir.driver.org.apache.hc.core5.util.Timeout;

public final class ApacheHttpClientChannels {
    private static final SafeLogger log = SafeLoggerFactory.get(ApacheHttpClientChannels.class);
    @VisibleForTesting
    static final Timeout DEFAULT_HANDSHAKE_TIMEOUT = Timeout.ofSeconds(10L);

    private ApacheHttpClientChannels() {
    }

    @Deprecated
    public static Channel create(ClientConfiguration conf) {
        return ApacheHttpClientChannels.create(conf, "apache-channel");
    }

    public static Channel create(ClientConfiguration conf, String channelName) {
        CloseableClient client = ApacheHttpClientChannels.createCloseableHttpClient(conf, channelName);
        return DialogueChannel.builder().channelName(channelName).clientConfiguration(conf).factory(args -> ApacheHttpClientChannels.createSingleUri(args, client)).build();
    }

    public static Channel createSingleUri(DialogueChannelFactory.ChannelArgs args, CloseableClient client) {
        ApacheHttpClientBlockingChannel blockingChannel = new ApacheHttpClientBlockingChannel(client, ApacheHttpClientChannels.url(args.uri()), args.resolvedAddress(), client.leakDetector(), args.uriIndexForInstrumentation());
        return client.executor() == null ? BlockingChannelAdapter.of(blockingChannel) : BlockingChannelAdapter.of(blockingChannel, client.executor());
    }

    public static Channel createSingleUri(String uri, CloseableClient client) {
        return ApacheHttpClientChannels.createSingleUri(DialogueChannelFactory.ChannelArgs.builder().uri(uri).build(), client);
    }

    public static CloseableClient createCloseableHttpClient(ClientConfiguration conf, String clientName) {
        return ApacheHttpClientChannels.clientBuilder().clientConfiguration(conf).clientName(clientName).build();
    }

    private static void setupConnectionPoolMetrics(TaggedMetricRegistry taggedMetrics, String clientName, PoolingHttpClientConnectionManager connectionManager) {
        DialogueClientPoolMetrics metrics = DialogueClientPoolMetrics.of(taggedMetrics);
        DialogueInternalWeakReducingGauge.getOrCreate(taggedMetrics, metrics.size().clientName(clientName).state("idle").buildMetricName(), pool -> pool.getTotalStats().getAvailable(), LongStream::sum, connectionManager);
        DialogueInternalWeakReducingGauge.getOrCreate(taggedMetrics, metrics.size().clientName(clientName).state("leased").buildMetricName(), pool -> pool.getTotalStats().getLeased(), LongStream::sum, connectionManager);
        DialogueInternalWeakReducingGauge.getOrCreate(taggedMetrics, metrics.size().clientName(clientName).state("pending").buildMetricName(), pool -> pool.getTotalStats().getPending(), LongStream::sum, connectionManager);
    }

    public static ClientBuilder clientBuilder() {
        return new ClientBuilder();
    }

    @Nullable
    private static InetSocketAddress getSocksProxyAddress() {
        String rawValue = System.getProperty("dialogue.experimental.socks5.proxy");
        if (Strings.isNullOrEmpty(rawValue)) {
            return null;
        }
        HostAndPort hostAndPort = HostAndPort.fromString(rawValue);
        return InetSocketAddress.createUnresolved(hostAndPort.getHost(), hostAndPort.getPort());
    }

    @Nullable
    private static InetSocketAddress getSocksProxyAddress(ClientConfiguration clientConfiguration) {
        try {
            InetSocketAddress address = clientConfiguration.proxy().select(URI.create("https://127.0.0.1")).stream().filter(proxy -> proxy.type() == Proxy.Type.SOCKS).map(Proxy::address).filter(InetSocketAddress.class::isInstance).map(InetSocketAddress.class::cast).findFirst().orElseGet(ApacheHttpClientChannels::getSocksProxyAddress);
            if (address != null) {
                log.debug("Found SOCKS proxy address", UnsafeArg.of("address", address));
            } else {
                log.debug("No SOCKS proxy found");
            }
            return address;
        }
        catch (RuntimeException e) {
            log.error("Failed to find a SOCKS proxy", e);
            return null;
        }
    }

    private static Timeout getSocketTimeout(ClientConfiguration conf, String clientName) {
        long socketTimeoutMillis = conf.readTimeout().toMillis();
        if (conf.readTimeout().toMillis() != conf.writeTimeout().toMillis()) {
            log.info("Read and write timeouts do not match, The value of the readTimeout {} will be used and write timeout {} will be ignored. Client: {}", SafeArg.of("readTimeout", conf.readTimeout()), SafeArg.of("writeTimeout", conf.writeTimeout()), SafeArg.of("client", clientName));
        }
        if (socketTimeoutMillis == 0L) {
            log.debug("Working around HTTPCLIENT-2099 by using a 1 day socket timeout instead of zero (unlimited). Client: {}", SafeArg.of("client", clientName));
            socketTimeoutMillis = Duration.ofDays(1L).toMillis();
        }
        return Timeout.ofMilliseconds(socketTimeoutMillis);
    }

    @VisibleForTesting
    static Timeout getHandshakeTimeout(Timeout connectTimeout, Timeout socketTimeout, String clientName) {
        if (connectTimeout.isEnabled()) {
            if (connectTimeout.toMilliseconds() >= DEFAULT_HANDSHAKE_TIMEOUT.toMilliseconds()) {
                return connectTimeout;
            }
            Timeout normalizedTimeout = Timeout.ofMilliseconds(Math.min(socketTimeout.toMilliseconds(), DEFAULT_HANDSHAKE_TIMEOUT.toMilliseconds()));
            log.info("Handshake timeout for client {} increased to {} from connect and socket timeouts {} and {}", SafeArg.of("client", clientName), SafeArg.of("handshakeTimeout", normalizedTimeout), SafeArg.of("connectTimeout", connectTimeout), SafeArg.of("socketTimeout", socketTimeout));
            return normalizedTimeout;
        }
        return socketTimeout;
    }

    private static String[] supportedCipherSuites(String[] cipherSuites, SSLSocketFactory socketFactory, String clientName) {
        ImmutableSet<String> jvmSupported = ApacheHttpClientChannels.supportedCipherSuites(socketFactory);
        ArrayList<String> enabled = new ArrayList<String>();
        ArrayList<String> unsupported = new ArrayList<String>();
        for (String cipherSuite : cipherSuites) {
            if (jvmSupported.contains(cipherSuite)) {
                enabled.add(cipherSuite);
                continue;
            }
            unsupported.add(cipherSuite);
        }
        if (!unsupported.isEmpty()) {
            log.debug("Skipping unsupported cipher suites", SafeArg.of("client", clientName), SafeArg.of("numEnabled", enabled.size()), SafeArg.of("numUnsupported", unsupported.size()), SafeArg.of("cipher", unsupported), SafeArg.of("javaVendor", System.getProperty("java.vendor")), SafeArg.of("javaVersion", System.getProperty("java.version")));
        }
        Preconditions.checkState(!enabled.isEmpty(), "Zero supported cipher suites");
        return enabled.toArray(new String[0]);
    }

    private static ImmutableSet<String> supportedCipherSuites(SSLSocketFactory socketFactory) {
        return ImmutableSet.copyOf(socketFactory.getSupportedCipherSuites());
    }

    private static URL url(String uri) {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new SafeIllegalArgumentException("Failed to parse URL", (Throwable)e, new Arg[0]);
        }
    }

    private static enum NullAuthenticationStrategy implements AuthenticationStrategy
    {
        INSTANCE;


        @Override
        public List<AuthScheme> select(ChallengeType _challengeType, Map<String, AuthChallenge> _challenges, HttpContext _context) {
            return Collections.emptyList();
        }
    }

    private static final class SingleCredentialsProvider
    implements CredentialsProvider {
        private final Credentials credentials;

        SingleCredentialsProvider(BasicCredentials basicCredentials) {
            this.credentials = new UsernamePasswordCredentials(basicCredentials.username(), basicCredentials.password().toCharArray());
        }

        @Override
        public Credentials getCredentials(AuthScope _authScope, HttpContext _context) {
            return this.credentials;
        }
    }

    private static enum NullCredentialsProvider implements CredentialsProvider
    {
        INSTANCE;


        @Override
        @Nullable
        public Credentials getCredentials(AuthScope _authScope, HttpContext _context) {
            return null;
        }
    }

    public static final class ClientBuilder {
        private static final Timeout IDLE_CONNECTION_TIMEOUT = Timeout.ofSeconds(50L);
        private static final TimeValue CONNECTION_INACTIVITY_CHECK = TimeValue.ofMilliseconds(Integer.getInteger("dialogue.experimental.inactivity.check.threshold.millis", 4000).intValue());
        @Nullable
        private ClientConfiguration clientConfiguration;
        @Nullable
        private String clientName;
        @Nullable
        private ExecutorService executor;
        private Optional<DialogueDnsResolver> dnsResolver = Optional.empty();

        private ClientBuilder() {
        }

        public ClientBuilder clientConfiguration(ClientConfiguration value) {
            this.clientConfiguration = Preconditions.checkNotNull(value, "ClientConfiguration is required");
            return this;
        }

        public ClientBuilder clientName(@Safe String value) {
            this.clientName = Preconditions.checkNotNull(value, "clientName is required");
            return this;
        }

        public ClientBuilder executor(ExecutorService value) {
            this.executor = Preconditions.checkNotNull(value, "ExecutorService is required");
            return this;
        }

        public ClientBuilder dnsResolver(DialogueDnsResolver value) {
            this.dnsResolver = Optional.of(Preconditions.checkNotNull(value, "DialogueDnsResolver is required"));
            return this;
        }

        public CloseableClient build() {
            ClientConfiguration conf = Preconditions.checkNotNull(this.clientConfiguration, "ClientConfiguration is required");
            String name = Preconditions.checkNotNull(this.clientName, "Client name is required");
            Preconditions.checkArgument(!conf.fallbackToCommonNameVerification(), "fallback-to-common-name-verification is not supported");
            Preconditions.checkArgument(!conf.meshProxy().isPresent(), "Mesh proxy is not supported");
            Timeout socketTimeout = ApacheHttpClientChannels.getSocketTimeout(conf, name);
            Timeout connectTimeout = Timeout.ofMilliseconds(conf.connectTimeout().toMillis());
            Timeout handshakeTimeout = ApacheHttpClientChannels.getHandshakeTimeout(connectTimeout, socketTimeout, name);
            InetSocketAddress socksProxyAddress = ApacheHttpClientChannels.getSocksProxyAddress(conf);
            SSLSocketFactory rawSocketFactory = conf.sslSocketFactory();
            Supplier<Socket> simpleSocketCreator = socksProxyAddress == null ? () -> new Socket(Proxy.NO_PROXY) : () -> new Socket(new Proxy(Proxy.Type.SOCKS, socksProxyAddress));
            ConnectInstrumentation connectInstrumentation = new ConnectInstrumentation(conf.taggedMetricRegistry(), name);
            PoolingHttpClientConnectionManager internalConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register(URIScheme.HTTP.id, new InstrumentedPlainConnectionSocketFactory(simpleSocketCreator, connectInstrumentation)).register(URIScheme.HTTPS.id, (InstrumentedPlainConnectionSocketFactory)((Object)new InstrumentedSslConnectionSocketFactory(connectInstrumentation, MetricRegistries.instrument(conf.taggedMetricRegistry(), rawSocketFactory, name), TlsProtocols.get(), ApacheHttpClientChannels.supportedCipherSuites(CipherSuites.allCipherSuites(), rawSocketFactory, name), new InstrumentedHostnameVerifier(new DefaultHostnameVerifier(), name, conf.taggedMetricRegistry()), simpleSocketCreator))).build(), PoolConcurrencyPolicy.LAX, PoolReusePolicy.LIFO, TimeValue.NEG_ONE_MILLISECOND, null, new InstrumentedDnsResolver(SystemDefaultDnsResolver.INSTANCE, this.dnsResolver, name, conf.taggedMetricRegistry()), new InstrumentedManagedHttpConnectionFactory(ManagedHttpClientConnectionFactory.INSTANCE, conf.taggedMetricRegistry(), name));
            internalConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).setSoTimeout(handshakeTimeout).setSocksProxyAddress(socksProxyAddress).build());
            internalConnectionManager.setValidateAfterInactivity(CONNECTION_INACTIVITY_CHECK);
            internalConnectionManager.setMaxTotal(Integer.MAX_VALUE);
            internalConnectionManager.setDefaultMaxPerRoute(Integer.MAX_VALUE);
            ApacheHttpClientChannels.setupConnectionPoolMetrics(conf.taggedMetricRegistry(), name, internalConnectionManager);
            InstrumentedPoolingHttpClientConnectionManager connectionManager = new InstrumentedPoolingHttpClientConnectionManager(internalConnectionManager, conf.taggedMetricRegistry(), name);
            HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).setResponseTimeout(socketTimeout).setRedirectsEnabled(false).setAuthenticationEnabled(conf.proxyCredentials().isPresent()).setExpectContinueEnabled(false).setConnectionKeepAlive(IDLE_CONNECTION_TIMEOUT).build()).setConnectionManagerShared(true).setKeepAliveStrategy(new InactivityValidationAwareConnectionKeepAliveStrategy(internalConnectionManager, name)).setConnectionManager(connectionManager).setRoutePlanner(new DialogueRoutePlanner(conf.proxy())).disableAutomaticRetries().disableConnectionState().disableCookieManagement().disableContentCompression().setDefaultCredentialsProvider(NullCredentialsProvider.INSTANCE).setTargetAuthenticationStrategy(NullAuthenticationStrategy.INSTANCE).setProxyAuthenticationStrategy(NullAuthenticationStrategy.INSTANCE).addExecInterceptorFirst("HttpClientExecRuntimeAttributeInterceptor", HttpClientExecRuntimeAttributeInterceptor.INSTANCE).setDefaultAuthSchemeRegistry(RegistryBuilder.create().build());
            conf.proxyCredentials().ifPresent(credentials -> builder.setDefaultCredentialsProvider(new SingleCredentialsProvider((BasicCredentials)credentials)).setProxyAuthenticationStrategy(DefaultAuthenticationStrategy.INSTANCE).setDefaultAuthSchemeRegistry(RegistryBuilder.create().register("Basic", BasicSchemeFactory.INSTANCE).build()));
            CloseableHttpClient apacheClient = builder.build();
            ScheduledFuture<?> connectionEvictorFuture = ScheduledIdleConnectionEvictor.schedule(connectionManager, Duration.ofSeconds(5L));
            return CloseableClient.wrap(apacheClient, name, connectionManager, connectionEvictorFuture, conf, this.executor);
        }
    }

    private static final class CloseableClientImpl
    extends CloseableClient {
        private final String clientName;
        private final CloseableHttpClient apacheClient;
        private final InstrumentedPoolingHttpClientConnectionManager pool;
        private final ResponseLeakDetector leakDetector;
        private final ClientConfiguration clientConfiguration;
        @Nullable
        private final ExecutorService executor;
        private final Closer closer = Closer.create();

        private CloseableClientImpl(CloseableHttpClient apacheClient, @Safe String clientName, InstrumentedPoolingHttpClientConnectionManager pool, ScheduledFuture<?> connectionEvictorFuture, ResponseLeakDetector leakDetector, @Nullable ExecutorService executor, ClientConfiguration clientConfiguration) {
            this.clientName = clientName;
            this.apacheClient = apacheClient;
            this.pool = pool;
            this.leakDetector = leakDetector;
            this.executor = executor;
            this.clientConfiguration = clientConfiguration;
            this.closer.register(() -> connectionEvictorFuture.cancel(true));
            this.closer.register(apacheClient);
            this.closer.register(pool::closeUnderlyingConnectionManager);
            this.closer.register(DialogueClientMetrics.of(clientConfiguration.taggedMetricRegistry()).close(clientName)::mark);
        }

        @Override
        CloseableHttpClient apacheClient() {
            return this.apacheClient;
        }

        @Override
        ClientConfiguration clientConfiguration() {
            return this.clientConfiguration;
        }

        @Override
        String name() {
            return this.clientName;
        }

        @Override
        @Nullable
        ExecutorService executor() {
            return this.executor;
        }

        @Override
        ResponseLeakDetector leakDetector() {
            return this.leakDetector;
        }

        @Override
        public void close() throws IOException {
            if (log.isDebugEnabled()) {
                PoolStats poolStats = this.pool.getTotalStats();
                log.debug("ApacheHttpClientChannels#close - {} {} {} {} {}", SafeArg.of("name", this.clientName), SafeArg.of("client", Integer.toHexString(System.identityHashCode(this.apacheClient))), SafeArg.of("idle", poolStats.getAvailable()), SafeArg.of("leased", poolStats.getLeased()), SafeArg.of("pending", poolStats.getPending()), new SafeRuntimeException("Exception for stacktrace", new Arg[0]));
            }
            this.pool.closeIdle(TimeValue.ZERO_MILLISECONDS);
        }

        private void closeApacheClient() {
            if (log.isInfoEnabled()) {
                PoolStats poolStats = this.pool.getTotalStats();
                log.info("ApacheHttpClientChannels#finalize - {} {} {} {} {}", SafeArg.of("name", this.clientName), SafeArg.of("client", Integer.toHexString(System.identityHashCode(this.apacheClient))), SafeArg.of("idle", poolStats.getAvailable()), SafeArg.of("leased", poolStats.getLeased()), SafeArg.of("pending", poolStats.getPending()));
            }
            try {
                this.closer.close();
            }
            catch (IOException e) {
                log.warn("Failed to close client", e);
            }
        }

        public String toString() {
            return "CloseableClientImpl@" + Integer.toHexString(System.identityHashCode(this)) + "{clientName='" + this.clientName + "', client=" + this.apacheClient + ", pool=" + this.pool + ", leakDetector=" + this.leakDetector + ", executor=" + this.executor + "}";
        }
    }

    private static final class CloseableClientWrapper
    extends CloseableClient {
        private final CloseableClient delegate;

        CloseableClientWrapper(CloseableClient delegate) {
            this.delegate = delegate;
        }

        @Override
        public CloseableHttpClient apacheClient() {
            return this.delegate.apacheClient();
        }

        @Override
        public ClientConfiguration clientConfiguration() {
            return this.delegate.clientConfiguration();
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        @Nullable
        ExecutorService executor() {
            return this.delegate.executor();
        }

        @Override
        ResponseLeakDetector leakDetector() {
            return this.delegate.leakDetector();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        public String toString() {
            return "CloseableClientWrapper{" + this.delegate + "}";
        }
    }

    public static abstract class CloseableClient
    implements Closeable {
        static CloseableClient wrap(CloseableHttpClient apacheClient, @Safe String clientName, InstrumentedPoolingHttpClientConnectionManager pool, ScheduledFuture<?> connectionEvictorFuture, ClientConfiguration clientConfiguration, @Nullable ExecutorService executor) {
            ResponseLeakDetector leakDetector = ResponseLeakDetector.of(clientName, clientConfiguration.taggedMetricRegistry());
            CloseableClientImpl newInstance = new CloseableClientImpl(apacheClient, clientName, pool, connectionEvictorFuture, leakDetector, executor, clientConfiguration);
            if (log.isDebugEnabled()) {
                log.debug("Created Apache client {} {} {}", SafeArg.of("name", clientName), SafeArg.of("client", Integer.toHexString(System.identityHashCode(apacheClient))), UnsafeArg.of("executor", executor), new SafeRuntimeException("Created here", new Arg[0]));
            } else {
                log.info("Created Apache client {} {} {}", SafeArg.of("name", clientName), SafeArg.of("client", Integer.toHexString(System.identityHashCode(apacheClient))), UnsafeArg.of("executor", executor));
            }
            Meter createMeter = DialogueClientMetrics.of(clientConfiguration.taggedMetricRegistry()).create(clientName);
            createMeter.mark();
            CloseableClientWrapper wrapper = new CloseableClientWrapper(newInstance);
            CleanerSupport.register(wrapper, () -> newInstance.closeApacheClient());
            return wrapper;
        }

        abstract CloseableHttpClient apacheClient();

        abstract ClientConfiguration clientConfiguration();

        abstract String name();

        @Nullable
        abstract ExecutorService executor();

        abstract ResponseLeakDetector leakDetector();
    }
}

