/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueRoutePlanner;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.org.apache.hc.core5.http.protocol.HttpContext;

final class ConnectInstrumentation {
    private final Timer connectTimerSuccessDnsLookup;
    private final Timer connectTimerFailureDnsLookup;
    private final Timer connectTimerSuccessPreResolved;
    private final Timer connectTimerFailurePreResolved;

    ConnectInstrumentation(TaggedMetricRegistry registry, @Safe String clientName) {
        DialogueClientMetrics metrics = DialogueClientMetrics.of(registry);
        this.connectTimerSuccessDnsLookup = metrics.connectionConnect().clientName(clientName).result(DialogueClientMetrics.ConnectionConnect_Result.SUCCESS).address(DialogueClientMetrics.ConnectionConnect_Address.DNS_LOOKUP).build();
        this.connectTimerFailureDnsLookup = metrics.connectionConnect().clientName(clientName).result(DialogueClientMetrics.ConnectionConnect_Result.FAILURE).address(DialogueClientMetrics.ConnectionConnect_Address.DNS_LOOKUP).build();
        this.connectTimerSuccessPreResolved = metrics.connectionConnect().clientName(clientName).result(DialogueClientMetrics.ConnectionConnect_Result.SUCCESS).address(DialogueClientMetrics.ConnectionConnect_Address.PRE_RESOLVED).build();
        this.connectTimerFailurePreResolved = metrics.connectionConnect().clientName(clientName).result(DialogueClientMetrics.ConnectionConnect_Result.FAILURE).address(DialogueClientMetrics.ConnectionConnect_Address.PRE_RESOLVED).build();
    }

    Timer timer(boolean success, HttpContext context) {
        if (DialogueRoutePlanner.hasPreResolvedAddress(context)) {
            return success ? this.connectTimerSuccessPreResolved : this.connectTimerFailurePreResolved;
        }
        return success ? this.connectTimerSuccessDnsLookup : this.connectTimerFailureDnsLookup;
    }
}

