/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueClientMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "4.0.0";
    private final TaggedMetricRegistry registry;

    private DialogueClientMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueClientMetrics of(TaggedMetricRegistry registry) {
        return new DialogueClientMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    ResponseLeakBuilderClientNameStage responseLeak() {
        return new ResponseLeakBuilder();
    }

    @CheckReturnValue
    Timer serverTimingOverhead(@Safe String clientName) {
        return this.registry.timer(DialogueClientMetrics.serverTimingOverheadMetricName(clientName));
    }

    static MetricName serverTimingOverheadMetricName(@Safe String clientName) {
        return MetricName.builder().safeName("dialogue.client.server.timing.overhead").putSafeTags("client-name", clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    Meter create(@Safe String clientName) {
        return this.registry.meter(DialogueClientMetrics.createMetricName(clientName));
    }

    static MetricName createMetricName(@Safe String clientName) {
        return MetricName.builder().safeName("dialogue.client.create").putSafeTags("client-name", clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    Meter close(@Safe String clientName) {
        return this.registry.meter(DialogueClientMetrics.closeMetricName(clientName));
    }

    static MetricName closeMetricName(@Safe String clientName) {
        return MetricName.builder().safeName("dialogue.client.close").putSafeTags("client-name", clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    ConnectionCreateBuilderClientNameStage connectionCreate() {
        return new ConnectionCreateBuilder();
    }

    @CheckReturnValue
    ConnectionConnectBuilderClientNameStage connectionConnect() {
        return new ConnectionConnectBuilder();
    }

    @CheckReturnValue
    Meter connectionClosedPartiallyConsumedResponse(@Safe String clientName) {
        return this.registry.meter(DialogueClientMetrics.connectionClosedPartiallyConsumedResponseMetricName(clientName));
    }

    static MetricName connectionClosedPartiallyConsumedResponseMetricName(@Safe String clientName) {
        return MetricName.builder().safeName("dialogue.client.connection.closed.partially-consumed-response").putSafeTags("client-name", clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    ConnectionCreateErrorBuilderClientNameStage connectionCreateError() {
        return new ConnectionCreateErrorBuilder();
    }

    @CheckReturnValue
    Meter connectionResolutionError(@Safe String clientName) {
        return this.registry.meter(DialogueClientMetrics.connectionResolutionErrorMetricName(clientName));
    }

    static MetricName connectionResolutionErrorMetricName(@Safe String clientName) {
        return MetricName.builder().safeName("dialogue.client.connection.resolution.error").putSafeTags("client-name", clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    ConnectionInsecureCipherBuilderClientNameStage connectionInsecureCipher() {
        return new ConnectionInsecureCipherBuilder();
    }

    public String toString() {
        return "DialogueClientMetrics{registry=" + this.registry + "}";
    }

    private final class ConnectionInsecureCipherBuilder
    implements ConnectionInsecureCipherBuilderClientNameStage,
    ConnectionInsecureCipherBuilderCipherStage,
    ConnectionInsecureCipherBuildStage {
        private String clientName;
        private String cipher;

        private ConnectionInsecureCipherBuilder() {
        }

        @Override
        public ConnectionInsecureCipherBuilder clientName(@Safe String clientName) {
            Preconditions.checkState(this.clientName == null, "client-name is already set");
            this.clientName = Preconditions.checkNotNull(clientName, "client-name is required");
            return this;
        }

        @Override
        public ConnectionInsecureCipherBuilder cipher(@Safe String cipher) {
            Preconditions.checkState(this.cipher == null, "cipher is already set");
            this.cipher = Preconditions.checkNotNull(cipher, "cipher is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.connection.insecure.cipher").putSafeTags("client-name", this.clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("cipher", this.cipher).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ConnectionInsecureCipherBuilderCipherStage {
        @CheckReturnValue
        public ConnectionInsecureCipherBuildStage cipher(@Safe String var1);
    }

    static interface ConnectionInsecureCipherBuilderClientNameStage {
        @CheckReturnValue
        public ConnectionInsecureCipherBuilderCipherStage clientName(@Safe String var1);
    }

    static interface ConnectionInsecureCipherBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    private final class ConnectionCreateErrorBuilder
    implements ConnectionCreateErrorBuilderClientNameStage,
    ConnectionCreateErrorBuilderCauseStage,
    ConnectionCreateErrorBuildStage {
        private String clientName;
        private String cause;

        private ConnectionCreateErrorBuilder() {
        }

        @Override
        public ConnectionCreateErrorBuilder clientName(@Safe String clientName) {
            Preconditions.checkState(this.clientName == null, "client-name is already set");
            this.clientName = Preconditions.checkNotNull(clientName, "client-name is required");
            return this;
        }

        @Override
        public ConnectionCreateErrorBuilder cause(@Safe String cause) {
            Preconditions.checkState(this.cause == null, "cause is already set");
            this.cause = Preconditions.checkNotNull(cause, "cause is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.connection.create.error").putSafeTags("client-name", this.clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("cause", this.cause).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ConnectionCreateErrorBuilderCauseStage {
        @CheckReturnValue
        public ConnectionCreateErrorBuildStage cause(@Safe String var1);
    }

    static interface ConnectionCreateErrorBuilderClientNameStage {
        @CheckReturnValue
        public ConnectionCreateErrorBuilderCauseStage clientName(@Safe String var1);
    }

    static interface ConnectionCreateErrorBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    private final class ConnectionConnectBuilder
    implements ConnectionConnectBuilderClientNameStage,
    ConnectionConnectBuilderResultStage,
    ConnectionConnectBuilderAddressStage,
    ConnectionConnectBuildStage {
        private String clientName;
        private ConnectionConnect_Result result;
        private ConnectionConnect_Address address;

        private ConnectionConnectBuilder() {
        }

        @Override
        public ConnectionConnectBuilder clientName(@Safe String clientName) {
            Preconditions.checkState(this.clientName == null, "client-name is already set");
            this.clientName = Preconditions.checkNotNull(clientName, "client-name is required");
            return this;
        }

        @Override
        public ConnectionConnectBuilder result(@Safe ConnectionConnect_Result result) {
            Preconditions.checkState(this.result == null, "result is already set");
            this.result = Preconditions.checkNotNull(result, "result is required");
            return this;
        }

        @Override
        public ConnectionConnectBuilder address(@Safe ConnectionConnect_Address address) {
            Preconditions.checkState(this.address == null, "address is already set");
            this.address = Preconditions.checkNotNull(address, "address is required");
            return this;
        }

        @Override
        public Timer build() {
            return DialogueClientMetrics.this.registry.timer(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.connection.connect").putSafeTags("client-name", this.clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("result", this.result.getValue()).putSafeTags("address", this.address.getValue()).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ConnectionConnectBuilderAddressStage {
        @CheckReturnValue
        public ConnectionConnectBuildStage address(@Safe ConnectionConnect_Address var1);
    }

    static interface ConnectionConnectBuilderResultStage {
        @CheckReturnValue
        public ConnectionConnectBuilderAddressStage result(@Safe ConnectionConnect_Result var1);
    }

    static interface ConnectionConnectBuilderClientNameStage {
        @CheckReturnValue
        public ConnectionConnectBuilderResultStage clientName(@Safe String var1);
    }

    static interface ConnectionConnectBuildStage {
        @CheckReturnValue
        public Timer build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static enum ConnectionConnect_Address {
        PRE_RESOLVED("pre-resolved"),
        DNS_LOOKUP("dns-lookup");

        private final String value;

        private ConnectionConnect_Address(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }

    static enum ConnectionConnect_Result {
        SUCCESS("success"),
        FAILURE("failure");

        private final String value;

        private ConnectionConnect_Result(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }

    private final class ConnectionCreateBuilder
    implements ConnectionCreateBuilderClientNameStage,
    ConnectionCreateBuilderResultStage,
    ConnectionCreateBuilderAddressStage,
    ConnectionCreateBuildStage {
        private String clientName;
        private ConnectionCreate_Result result;
        private ConnectionCreate_Address address;

        private ConnectionCreateBuilder() {
        }

        @Override
        public ConnectionCreateBuilder clientName(@Safe String clientName) {
            Preconditions.checkState(this.clientName == null, "client-name is already set");
            this.clientName = Preconditions.checkNotNull(clientName, "client-name is required");
            return this;
        }

        @Override
        public ConnectionCreateBuilder result(@Safe ConnectionCreate_Result result) {
            Preconditions.checkState(this.result == null, "result is already set");
            this.result = Preconditions.checkNotNull(result, "result is required");
            return this;
        }

        @Override
        public ConnectionCreateBuilder address(@Safe ConnectionCreate_Address address) {
            Preconditions.checkState(this.address == null, "address is already set");
            this.address = Preconditions.checkNotNull(address, "address is required");
            return this;
        }

        @Override
        public Timer build() {
            return DialogueClientMetrics.this.registry.timer(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.connection.create").putSafeTags("client-name", this.clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("result", this.result.getValue()).putSafeTags("address", this.address.getValue()).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ConnectionCreateBuilderAddressStage {
        @CheckReturnValue
        public ConnectionCreateBuildStage address(@Safe ConnectionCreate_Address var1);
    }

    static interface ConnectionCreateBuilderResultStage {
        @CheckReturnValue
        public ConnectionCreateBuilderAddressStage result(@Safe ConnectionCreate_Result var1);
    }

    static interface ConnectionCreateBuilderClientNameStage {
        @CheckReturnValue
        public ConnectionCreateBuilderResultStage clientName(@Safe String var1);
    }

    static interface ConnectionCreateBuildStage {
        @CheckReturnValue
        public Timer build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static enum ConnectionCreate_Address {
        PRE_RESOLVED("pre-resolved"),
        DNS_LOOKUP("dns-lookup");

        private final String value;

        private ConnectionCreate_Address(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }

    static enum ConnectionCreate_Result {
        SUCCESS("success"),
        FAILURE("failure");

        private final String value;

        private ConnectionCreate_Result(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }

    private final class ResponseLeakBuilder
    implements ResponseLeakBuilderClientNameStage,
    ResponseLeakBuilderServiceNameStage,
    ResponseLeakBuilderEndpointStage,
    ResponseLeakBuildStage {
        private String clientName;
        private String serviceName;
        private String endpoint;

        private ResponseLeakBuilder() {
        }

        @Override
        public ResponseLeakBuilder clientName(@Safe String clientName) {
            Preconditions.checkState(this.clientName == null, "client-name is already set");
            this.clientName = Preconditions.checkNotNull(clientName, "client-name is required");
            return this;
        }

        @Override
        public ResponseLeakBuilder serviceName(@Safe String serviceName) {
            Preconditions.checkState(this.serviceName == null, "service-name is already set");
            this.serviceName = Preconditions.checkNotNull(serviceName, "service-name is required");
            return this;
        }

        @Override
        public ResponseLeakBuilder endpoint(@Safe String endpoint) {
            Preconditions.checkState(this.endpoint == null, "endpoint is already set");
            this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint is required");
            return this;
        }

        @Override
        public Meter build() {
            return DialogueClientMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.response.leak").putSafeTags("client-name", this.clientName).putSafeTags("client-type", "apache-hc5").putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).putSafeTags("libraryName", DialogueClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ResponseLeakBuilderEndpointStage {
        @CheckReturnValue
        public ResponseLeakBuildStage endpoint(@Safe String var1);
    }

    static interface ResponseLeakBuilderServiceNameStage {
        @CheckReturnValue
        public ResponseLeakBuilderEndpointStage serviceName(@Safe String var1);
    }

    static interface ResponseLeakBuilderClientNameStage {
        @CheckReturnValue
        public ResponseLeakBuilderServiceNameStage clientName(@Safe String var1);
    }

    static interface ResponseLeakBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

