/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Gauge;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class DialogueClientPoolMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "4.0.0";
    private final TaggedMetricRegistry registry;

    private DialogueClientPoolMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static DialogueClientPoolMetrics of(TaggedMetricRegistry registry) {
        return new DialogueClientPoolMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    SizeBuilderClientNameStage size() {
        return new SizeBuilder();
    }

    public String toString() {
        return "DialogueClientPoolMetrics{registry=" + this.registry + "}";
    }

    private final class SizeBuilder
    implements SizeBuilderClientNameStage,
    SizeBuilderStateStage,
    SizeBuildStage {
        private String clientName;
        private String state;

        private SizeBuilder() {
        }

        @Override
        public SizeBuilder clientName(@Safe String clientName) {
            Preconditions.checkState(this.clientName == null, "client-name is already set");
            this.clientName = Preconditions.checkNotNull(clientName, "client-name is required");
            return this;
        }

        @Override
        public SizeBuilder state(@Safe String state) {
            Preconditions.checkState(this.state == null, "state is already set");
            this.state = Preconditions.checkNotNull(state, "state is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            DialogueClientPoolMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("dialogue.client.pool.size").putSafeTags("client-name", this.clientName).putSafeTags("state", this.state).putSafeTags("libraryName", DialogueClientPoolMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", DialogueClientPoolMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface SizeBuilderStateStage {
        @CheckReturnValue
        public SizeBuildStage state(@Safe String var1);
    }

    static interface SizeBuilderClientNameStage {
        @CheckReturnValue
        public SizeBuilderStateStage clientName(@Safe String var1);
    }

    static interface SizeBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

