/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import java.net.InetAddress;
import java.net.ProxySelector;
import shadow.palantir.driver.com.palantir.dialogue.hc5.HttpsProxyDefaultRoutePlanner;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.org.apache.hc.client5.http.HttpRoute;
import shadow.palantir.driver.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpException;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpHost;
import shadow.palantir.driver.org.apache.hc.core5.http.protocol.HttpContext;

final class DialogueRoutePlanner
implements HttpRoutePlanner {
    private static final String ATTRIBUTE = "dialogueResolvedAddress";
    private final HttpRoutePlanner delegate;

    DialogueRoutePlanner(ProxySelector proxySelector) {
        this.delegate = new HttpsProxyDefaultRoutePlanner(proxySelector);
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpContext context) throws HttpException {
        InetAddress resolvedAddress;
        HttpRoute route = this.delegate.determineRoute(host, context);
        if (route.getTargetHost().getAddress() == null && (resolvedAddress = DialogueRoutePlanner.get(context)) != null) {
            return DialogueRoutePlanner.withResolvedAddress(route, resolvedAddress);
        }
        return route;
    }

    private static HttpRoute withResolvedAddress(HttpRoute route, InetAddress resolvedAddress) {
        HttpHost targetHost = route.getTargetHost();
        return new HttpRoute(new HttpHost(targetHost.getSchemeName(), resolvedAddress, targetHost.getHostName(), targetHost.getPort()), route.getLocalAddress(), DialogueRoutePlanner.extractProxies(route), route.isSecure(), route.getTunnelType(), route.getLayerType());
    }

    @Nullable
    private static HttpHost[] extractProxies(HttpRoute route) {
        int hops = route.getHopCount();
        if (hops > 1) {
            HttpHost[] proxies = new HttpHost[hops - 1];
            for (int i = 0; i < hops - 1; ++i) {
                proxies[i] = route.getHopTarget(i);
            }
            return proxies;
        }
        return null;
    }

    static void set(HttpContext context, InetAddress resolvedAddress) {
        context.setAttribute(ATTRIBUTE, resolvedAddress);
    }

    static boolean hasPreResolvedAddress(HttpContext context) {
        return context != null && DialogueRoutePlanner.get(context) != null;
    }

    @Nullable
    private static InetAddress get(HttpContext context) {
        Object value = context.getAttribute(ATTRIBUTE);
        if (value instanceof InetAddress) {
            return (InetAddress)value;
        }
        return null;
    }
}

