/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import shadow.palantir.driver.com.google.common.util.concurrent.RateLimiter;
import shadow.palantir.driver.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import shadow.palantir.driver.org.apache.hc.client5.http.config.RequestConfig;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import shadow.palantir.driver.org.apache.hc.client5.http.protocol.HttpClientContext;
import shadow.palantir.driver.org.apache.hc.core5.http.HeaderElement;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpResponse;
import shadow.palantir.driver.org.apache.hc.core5.http.message.MessageSupport;
import shadow.palantir.driver.org.apache.hc.core5.http.protocol.HttpContext;
import shadow.palantir.driver.org.apache.hc.core5.util.TimeValue;

final class InactivityValidationAwareConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    private static final SafeLogger log = SafeLoggerFactory.get(InactivityValidationAwareConnectionKeepAliveStrategy.class);
    private static final String TIMEOUT_ELEMENT = "timeout";
    private final PoolingHttpClientConnectionManager connectionManager;
    private final String clientName;
    private final TimeValue defaultValidateAfterInactivity;
    private final RateLimiter loggingRateLimiter = RateLimiter.create(2.0);
    private final AtomicReference<TimeValue> currentValidationInterval;

    InactivityValidationAwareConnectionKeepAliveStrategy(PoolingHttpClientConnectionManager connectionManager, String clientName) {
        this.connectionManager = connectionManager;
        this.clientName = clientName;
        this.defaultValidateAfterInactivity = connectionManager.getValidateAfterInactivity();
        this.currentValidationInterval = new AtomicReference<TimeValue>(this.defaultValidateAfterInactivity);
    }

    @Override
    public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Iterator<HeaderElement> headerElementIterator = MessageSupport.iterate(response, "keep-alive");
        while (headerElementIterator.hasNext()) {
            HeaderElement headerElement = headerElementIterator.next();
            String headerElementName = headerElement.getName();
            String headerElementValue = headerElement.getValue();
            if (headerElementValue == null || !TIMEOUT_ELEMENT.equalsIgnoreCase(headerElementName)) continue;
            try {
                long keepAliveTimeoutSeconds = Long.parseLong(headerElementValue);
                if (keepAliveTimeoutSeconds <= 0L) continue;
                TimeValue keepAliveValue = TimeValue.ofSeconds(keepAliveTimeoutSeconds);
                this.updateInactivityValidationInterval(response.getCode(), keepAliveValue);
                return keepAliveValue;
            }
            catch (NumberFormatException nfe) {
                log.debug("invalid timeout value {}", SafeArg.of("timeoutValue", headerElementValue), (Throwable)nfe);
            }
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        this.updateInactivityValidationInterval(response.getCode(), this.defaultValidateAfterInactivity);
        return requestConfig.getConnectionKeepAlive();
    }

    private void updateInactivityValidationInterval(int statusCode, TimeValue newInterval) {
        if (statusCode / 100 == 2) {
            TimeValue previousInterval = this.currentValidationInterval.getAndSet(newInterval);
            if (!Objects.equals(previousInterval, newInterval) && (this.loggingRateLimiter.tryAcquire() || log.isDebugEnabled())) {
                log.info("Updating the validation interval for {} from {} to {}", SafeArg.of("client", this.clientName), SafeArg.of("previousInterval", previousInterval), SafeArg.of("newInterval", newInterval));
            }
            this.connectionManager.setValidateAfterInactivity(newInterval);
        }
    }
}

