/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeExceptions;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.google.errorprone.annotations.CompileTimeConstant;
import shadow.palantir.driver.com.palantir.dialogue.core.DialogueDnsResolver;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.tracing.CloseableTracer;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.org.apache.hc.client5.http.DnsResolver;

final class InstrumentedDnsResolver
implements DnsResolver {
    private static final SafeLogger log = SafeLoggerFactory.get(InstrumentedDnsResolver.class);
    private final DnsResolver delegate;
    private final Optional<DialogueDnsResolver> dialogueDnsResolver;
    private final Meter errorMeter;
    private final String clientName;

    InstrumentedDnsResolver(DnsResolver delegate, Optional<DialogueDnsResolver> dialogueDnsResolver, String clientName, TaggedMetricRegistry metricRegistry) {
        this.delegate = delegate;
        this.dialogueDnsResolver = dialogueDnsResolver;
        this.clientName = clientName;
        this.errorMeter = DialogueClientMetrics.of(metricRegistry).connectionResolutionError(clientName);
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        boolean debugLoggingEnabled = log.isDebugEnabled();
        long startNanos = debugLoggingEnabled ? System.nanoTime() : -1L;
        CloseableTracer ignored = CloseableTracer.startSpan("DnsResolver.resolve");
        try {
            InetAddress[] resolved = this.internalHostnameResolution(host);
            if (debugLoggingEnabled) {
                long durationNanos = System.nanoTime() - startNanos;
                log.debug("DnsResolver.resolve({}) on client {} produced '{}' ({} results) after {} ns", UnsafeArg.of("host", host), SafeArg.of("client", this.clientName), resolved == null ? SafeArg.of("resolved", "null") : UnsafeArg.of("resolved", resolved), SafeArg.of("numResolved", resolved == null ? 0 : resolved.length), SafeArg.of("durationNanos", durationNanos));
            }
            InetAddress[] inetAddressArray = resolved;
            if (ignored != null) {
                ignored.close();
            }
            return inetAddressArray;
        }
        catch (Throwable resolved) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        resolved.addSuppressed(throwable);
                    }
                }
                throw resolved;
            }
            catch (Throwable t) {
                this.recordFailure();
                if (debugLoggingEnabled) {
                    long durationNanos = System.nanoTime() - startNanos;
                    log.debug("DnsResolver.resolve({}) on client {} failed after {} ns", UnsafeArg.of("host", host), SafeArg.of("client", this.clientName), SafeArg.of("durationNanos", durationNanos), t);
                }
                throw t;
            }
        }
    }

    private InetAddress[] internalHostnameResolution(String host) throws UnknownHostException {
        if (this.dialogueDnsResolver.isPresent()) {
            DialogueDnsResolver resolver = this.dialogueDnsResolver.get();
            ImmutableSet<InetAddress> resolved = resolver.resolve(Strings.nullToEmpty(host));
            if (resolved.isEmpty()) {
                throw new SafeUnknownHostException("Failed to resolve host", SafeArg.of("client", this.clientName), UnsafeArg.of("host", host));
            }
            return (InetAddress[])resolved.toArray(InetAddress[]::new);
        }
        return this.delegate.resolve(host);
    }

    @Override
    public String resolveCanonicalHostname(String host) throws UnknownHostException {
        boolean debugLoggingEnabled = log.isDebugEnabled();
        long startNanos = debugLoggingEnabled ? System.nanoTime() : -1L;
        CloseableTracer ignored = CloseableTracer.startSpan("DnsResolver.resolveCanonicalHostname");
        try {
            String resolved = this.delegate.resolveCanonicalHostname(host);
            if (debugLoggingEnabled) {
                long durationNanos = System.nanoTime() - startNanos;
                log.debug("DnsResolver.resolveCanonicalHostname({}) on client {} produced '{}' after {} ns", UnsafeArg.of("host", host), SafeArg.of("client", this.clientName), UnsafeArg.of("resolved", resolved), SafeArg.of("durationNanos", durationNanos));
            }
            String string = resolved;
            if (ignored != null) {
                ignored.close();
            }
            return string;
        }
        catch (Throwable resolved) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        resolved.addSuppressed(throwable);
                    }
                }
                throw resolved;
            }
            catch (Throwable t) {
                this.recordFailure();
                if (debugLoggingEnabled) {
                    long durationNanos = System.nanoTime() - startNanos;
                    log.debug("DnsResolver.resolveCanonicalHostname({}) on client {} failed after {} ns", UnsafeArg.of("host", host), SafeArg.of("client", this.clientName), SafeArg.of("durationNanos", durationNanos), t);
                }
                throw t;
            }
        }
    }

    private void recordFailure() {
        this.errorMeter.mark();
    }

    public String toString() {
        return "InstrumentedDnsResolver{" + this.delegate + "}";
    }

    private static final class SafeUnknownHostException
    extends UnknownHostException
    implements SafeLoggable {
        @CompileTimeConstant
        private final String logMessage;
        private final List<Arg<?>> arguments;

        SafeUnknownHostException(@CompileTimeConstant String message, Arg<?> ... arguments) {
            super(SafeExceptions.renderMessage(message, arguments));
            this.logMessage = message;
            this.arguments = Collections.unmodifiableList(Arrays.asList(arguments));
        }

        @Override
        @Safe
        public String getLogMessage() {
            return this.logMessage;
        }

        @Override
        public List<Arg<?>> getArgs() {
            return this.arguments;
        }
    }
}

