/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.CipherSuites;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class InstrumentedHostnameVerifier
implements HostnameVerifier {
    private final String clientName;
    private final HostnameVerifier delegate;
    private final DialogueClientMetrics metrics;

    InstrumentedHostnameVerifier(HostnameVerifier delegate, String clientName, TaggedMetricRegistry registry) {
        this.delegate = delegate;
        this.clientName = clientName;
        this.metrics = DialogueClientMetrics.of(registry);
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        boolean result = this.delegate.verify(hostname, session);
        String cipher = session.getCipherSuite();
        if (CipherSuites.deprecatedCiphers().contains(cipher)) {
            this.metrics.connectionInsecureCipher().clientName(this.clientName).cipher(cipher).build().mark();
        }
        return result;
    }

    public String toString() {
        return "InstrumentedHostnameVerifier{clientName='" + this.clientName + "', delegate=" + this.delegate + "}";
    }
}

