/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ServerTimingParser;
import shadow.palantir.driver.org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import shadow.palantir.driver.org.apache.hc.core5.http.ClassicHttpRequest;
import shadow.palantir.driver.org.apache.hc.core5.http.ClassicHttpResponse;
import shadow.palantir.driver.org.apache.hc.core5.http.EndpointDetails;
import shadow.palantir.driver.org.apache.hc.core5.http.Header;
import shadow.palantir.driver.org.apache.hc.core5.http.HttpException;
import shadow.palantir.driver.org.apache.hc.core5.http.ProtocolVersion;
import shadow.palantir.driver.org.apache.hc.core5.io.CloseMode;
import shadow.palantir.driver.org.apache.hc.core5.util.Timeout;

final class InstrumentedManagedHttpClientConnection
implements ManagedHttpClientConnection {
    private final ManagedHttpClientConnection delegate;
    private final Timer serverTimingOverhead;

    InstrumentedManagedHttpClientConnection(ManagedHttpClientConnection delegate, Timer serverTimingOverhead) {
        this.delegate = delegate;
        this.serverTimingOverhead = serverTimingOverhead;
    }

    @Override
    public void bind(Socket socket) throws IOException {
        this.delegate.bind(socket);
    }

    @Override
    public Socket getSocket() {
        return this.delegate.getSocket();
    }

    @Override
    public SSLSession getSSLSession() {
        return this.delegate.getSSLSession();
    }

    @Override
    public void passivate() {
        this.delegate.passivate();
    }

    @Override
    public void activate() {
        this.delegate.activate();
    }

    @Override
    public boolean isConsistent() {
        return this.delegate.isConsistent();
    }

    @Override
    public void sendRequestHeader(ClassicHttpRequest request) throws HttpException, IOException {
        this.delegate.sendRequestHeader(request);
    }

    @Override
    public void terminateRequest(ClassicHttpRequest request) throws HttpException, IOException {
        this.delegate.terminateRequest(request);
    }

    @Override
    public void sendRequestEntity(ClassicHttpRequest request) throws HttpException, IOException {
        this.delegate.sendRequestEntity(request);
    }

    @Override
    public ClassicHttpResponse receiveResponseHeader() throws HttpException, IOException {
        long startTimeNanos = System.nanoTime();
        ClassicHttpResponse response = this.delegate.receiveResponseHeader();
        this.recordTimingDelta(response, startTimeNanos);
        return response;
    }

    private void recordTimingDelta(ClassicHttpResponse httpClientResponse, long startTimeNanos) {
        Header serverTimingValue = httpClientResponse.getFirstHeader("Server-Timing");
        if (serverTimingValue != null) {
            long clientDurationNanos = System.nanoTime() - startTimeNanos;
            long serverNanos = ServerTimingParser.getServerDurationNanos(serverTimingValue.getValue(), "server");
            long deltaNanos = clientDurationNanos - serverNanos;
            if (serverNanos >= 0L && deltaNanos >= 0L) {
                this.serverTimingOverhead.update(deltaNanos, TimeUnit.NANOSECONDS);
            }
        }
    }

    @Override
    public void receiveResponseEntity(ClassicHttpResponse response) throws HttpException, IOException {
        this.delegate.receiveResponseEntity(response);
    }

    @Override
    public boolean isDataAvailable(Timeout timeout) throws IOException {
        return this.delegate.isDataAvailable(timeout);
    }

    @Override
    public boolean isStale() throws IOException {
        return this.delegate.isStale();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return this.delegate.getEndpointDetails();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.delegate.getProtocolVersion();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.delegate.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.delegate.setSocketTimeout(timeout);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.delegate.close(closeMode);
    }

    public String toString() {
        return "InstrumentedManagedHttpClientConnection{" + this.delegate + "}";
    }
}

