/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import java.io.IOException;
import java.net.Socket;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.hc5.InstrumentedManagedHttpClientConnection;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import shadow.palantir.driver.org.apache.hc.core5.http.io.HttpConnectionFactory;

final class InstrumentedManagedHttpConnectionFactory
implements HttpConnectionFactory<ManagedHttpClientConnection> {
    private final HttpConnectionFactory<ManagedHttpClientConnection> delegate;
    private final Timer serverTimingOverhead;

    InstrumentedManagedHttpConnectionFactory(HttpConnectionFactory<ManagedHttpClientConnection> delegate, TaggedMetricRegistry metrics, String clientName) {
        this.delegate = delegate;
        this.serverTimingOverhead = DialogueClientMetrics.of(metrics).serverTimingOverhead(clientName);
    }

    @Override
    public ManagedHttpClientConnection createConnection(Socket socket) throws IOException {
        return new InstrumentedManagedHttpClientConnection(this.delegate.createConnection(socket), this.serverTimingOverhead);
    }

    public String toString() {
        return "InstrumentedManagedHttpConnectionFactory{" + this.delegate + "}";
    }
}

