/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueRoutePlanner;
import shadow.palantir.driver.com.palantir.tracing.CloseableTracer;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.org.apache.hc.client5.http.HttpRoute;
import shadow.palantir.driver.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import shadow.palantir.driver.org.apache.hc.client5.http.io.ConnectionEndpoint;
import shadow.palantir.driver.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import shadow.palantir.driver.org.apache.hc.client5.http.io.LeaseRequest;
import shadow.palantir.driver.org.apache.hc.core5.http.protocol.HttpContext;
import shadow.palantir.driver.org.apache.hc.core5.io.CloseMode;
import shadow.palantir.driver.org.apache.hc.core5.pool.ConnPoolControl;
import shadow.palantir.driver.org.apache.hc.core5.pool.PoolStats;
import shadow.palantir.driver.org.apache.hc.core5.util.TimeValue;
import shadow.palantir.driver.org.apache.hc.core5.util.Timeout;

final class InstrumentedPoolingHttpClientConnectionManager
implements HttpClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private static final SafeLogger log = SafeLoggerFactory.get(InstrumentedPoolingHttpClientConnectionManager.class);
    private final PoolingHttpClientConnectionManager manager;
    private final DialogueClientMetrics metrics;
    private final String clientName;
    private final Timer connectTimerSuccessDnsLookup;
    private final Timer connectTimerFailureDnsLookup;
    private final Timer connectTimerSuccessPreResolved;
    private final Timer connectTimerFailurePreResolved;
    private volatile boolean closed;

    InstrumentedPoolingHttpClientConnectionManager(PoolingHttpClientConnectionManager manager, TaggedMetricRegistry registry, String clientName) {
        this.manager = manager;
        this.clientName = clientName;
        this.metrics = DialogueClientMetrics.of(registry);
        this.connectTimerSuccessDnsLookup = this.metrics.connectionCreate().clientName(clientName).result(DialogueClientMetrics.ConnectionCreate_Result.SUCCESS).address(DialogueClientMetrics.ConnectionCreate_Address.DNS_LOOKUP).build();
        this.connectTimerFailureDnsLookup = this.metrics.connectionCreate().clientName(clientName).result(DialogueClientMetrics.ConnectionCreate_Result.FAILURE).address(DialogueClientMetrics.ConnectionCreate_Address.DNS_LOOKUP).build();
        this.connectTimerSuccessPreResolved = this.metrics.connectionCreate().clientName(clientName).result(DialogueClientMetrics.ConnectionCreate_Result.SUCCESS).address(DialogueClientMetrics.ConnectionCreate_Address.PRE_RESOLVED).build();
        this.connectTimerFailurePreResolved = this.metrics.connectionCreate().clientName(clientName).result(DialogueClientMetrics.ConnectionCreate_Result.FAILURE).address(DialogueClientMetrics.ConnectionCreate_Address.PRE_RESOLVED).build();
    }

    @Override
    public void close() {
        if (!this.closed) {
            log.warn("Dialogue ConnectionManager close invoked unexpectedly and ignored", SafeArg.of("clientName", this.clientName), (Throwable)new SafeRuntimeException("stacktrace", new Arg[0]));
        }
    }

    @Override
    public void close(CloseMode closeMode) {
        if (!this.closed) {
            log.warn("Dialogue ConnectionManager close invoked unexpectedly and ignored", SafeArg.of("clientName", this.clientName), SafeArg.of("closeMode", closeMode), new SafeRuntimeException("stacktrace", new Arg[0]));
        }
    }

    void closeUnderlyingConnectionManager() {
        if (!this.closed) {
            this.closed = true;
            this.manager.close();
        }
    }

    @Override
    public LeaseRequest lease(String id, HttpRoute route, Timeout requestTimeout, Object state) {
        return this.manager.lease(id, route, requestTimeout, state);
    }

    @Override
    public void release(ConnectionEndpoint endpoint, Object state, TimeValue keepAlive) {
        this.manager.release(endpoint, state, keepAlive);
    }

    @Override
    public void connect(ConnectionEndpoint endpoint, TimeValue connectTimeout, HttpContext context) throws IOException {
        long beginNanos = System.nanoTime();
        try (CloseableTracer ignored = CloseableTracer.startSpan("Dialogue ConnectionManager.connect");){
            this.manager.connect(endpoint, connectTimeout, context);
            this.successTimer(context).update(System.nanoTime() - beginNanos, TimeUnit.NANOSECONDS);
        }
        catch (Throwable throwable) {
            this.failureTimer(context).update(System.nanoTime() - beginNanos, TimeUnit.NANOSECONDS);
            this.metrics.connectionCreateError().clientName(this.clientName).cause(throwable.getClass().getSimpleName()).build().mark();
            if (log.isDebugEnabled()) {
                log.debug("Failed to connect to endpoint", SafeArg.of("clientName", this.clientName), throwable);
            }
            throw throwable;
        }
    }

    private Timer successTimer(HttpContext context) {
        return DialogueRoutePlanner.hasPreResolvedAddress(context) ? this.connectTimerSuccessPreResolved : this.connectTimerSuccessDnsLookup;
    }

    private Timer failureTimer(HttpContext context) {
        return DialogueRoutePlanner.hasPreResolvedAddress(context) ? this.connectTimerFailurePreResolved : this.connectTimerFailureDnsLookup;
    }

    @Override
    public void upgrade(ConnectionEndpoint endpoint, HttpContext context) throws IOException {
        this.manager.upgrade(endpoint, context);
    }

    @Override
    public void closeIdle(TimeValue idleTime) {
        this.manager.closeIdle(idleTime);
    }

    @Override
    public void closeExpired() {
        this.manager.closeExpired();
    }

    @Override
    public Set<HttpRoute> getRoutes() {
        return this.manager.getRoutes();
    }

    @Override
    public int getMaxTotal() {
        return this.manager.getMaxTotal();
    }

    @Override
    public void setMaxTotal(int max) {
        this.manager.setMaxTotal(max);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.manager.getDefaultMaxPerRoute();
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        this.manager.setDefaultMaxPerRoute(max);
    }

    @Override
    public int getMaxPerRoute(HttpRoute route) {
        return this.manager.getMaxPerRoute(route);
    }

    @Override
    public void setMaxPerRoute(HttpRoute route, int max) {
        this.manager.setMaxPerRoute(route, max);
    }

    @Override
    public PoolStats getTotalStats() {
        return this.manager.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpRoute route) {
        return this.manager.getStats(route);
    }

    public String toString() {
        return "InstrumentedPoolingHttpClientConnectionManager{" + this.manager + "}";
    }
}

