/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.palantir.dialogue.hc5.ConnectInstrumentation;
import shadow.palantir.driver.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import shadow.palantir.driver.org.apache.hc.core5.http.protocol.HttpContext;
import shadow.palantir.driver.org.apache.hc.core5.util.Timeout;

final class InstrumentedSslConnectionSocketFactory
extends SSLConnectionSocketFactory {
    private final Supplier<Socket> rawSocketCreator;
    private final ConnectInstrumentation connectInstrumentation;

    InstrumentedSslConnectionSocketFactory(ConnectInstrumentation connectInstrumentation, SSLSocketFactory socketFactory, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier, Supplier<Socket> rawSocketCreator) {
        super(socketFactory, supportedProtocols, supportedCipherSuites, hostnameVerifier);
        this.connectInstrumentation = connectInstrumentation;
        this.rawSocketCreator = rawSocketCreator;
    }

    @Override
    public Socket createSocket(HttpContext _context) {
        return this.rawSocketCreator.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectSocket(Socket sock, InetSocketAddress remoteAddress, Timeout connectTimeout, HttpContext context) throws IOException {
        boolean success = false;
        long startNanos = System.nanoTime();
        try {
            super.connectSocket(sock, remoteAddress, connectTimeout, context);
            success = true;
        }
        finally {
            long durationNanos = System.nanoTime() - startNanos;
            Timer timer = this.connectInstrumentation.timer(success, context);
            timer.update(durationNanos, TimeUnit.NANOSECONDS);
        }
    }
}

