/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.collect.ListMultimap;
import shadow.palantir.driver.com.palantir.dialogue.Endpoint;
import shadow.palantir.driver.com.palantir.dialogue.Response;
import shadow.palantir.driver.com.palantir.dialogue.ResponseAttachments;
import shadow.palantir.driver.com.palantir.dialogue.hc5.CleanerSupport;
import shadow.palantir.driver.com.palantir.dialogue.hc5.DialogueClientMetrics;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.javax.annotation.Nullable;

final class ResponseLeakDetector {
    private static final SafeLogger log = SafeLoggerFactory.get(ResponseLeakDetector.class);
    private final String clientName;
    private final DialogueClientMetrics metrics;

    static ResponseLeakDetector of(String clientName, TaggedMetricRegistry metrics) {
        return new ResponseLeakDetector(clientName, DialogueClientMetrics.of(metrics));
    }

    ResponseLeakDetector(String clientName, DialogueClientMetrics metrics) {
        this.clientName = clientName;
        this.metrics = metrics;
    }

    Response wrap(Response input, Endpoint endpoint) {
        LeakDetector detector = new LeakDetector(input, endpoint, this.clientName, this.metrics);
        LeakDetectingResponse response = new LeakDetectingResponse(input, detector);
        return response;
    }

    public String toString() {
        return "ResponseLeakDetector{clientName='" + this.clientName + "}";
    }

    private static final class LeakDetectingResponse
    implements Response {
        private final Response delegate;
        private final LeakDetector leakDetector;
        private final Cleaner.Cleanable clean;
        @Nullable
        private InputStream leakDetectingStream;

        LeakDetectingResponse(Response delegate, LeakDetector leakDetector) {
            this.delegate = delegate;
            this.leakDetector = leakDetector;
            this.clean = CleanerSupport.register(this, leakDetector);
        }

        @Override
        public InputStream body() {
            if (this.leakDetectingStream == null) {
                this.leakDetectingStream = new LeakDetectingInputStream(this.delegate.body(), this);
            }
            return this.leakDetectingStream;
        }

        @Override
        public int code() {
            return this.delegate.code();
        }

        @Override
        public ListMultimap<String, String> headers() {
            return this.delegate.headers();
        }

        @Override
        public Optional<String> getFirstHeader(String header) {
            return this.delegate.getFirstHeader(header);
        }

        @Override
        public ResponseAttachments attachments() {
            return this.delegate.attachments();
        }

        @Override
        public void close() {
            try {
                this.disarm();
            }
            finally {
                this.delegate.close();
            }
        }

        void disarm() {
            this.leakDetector.disarm();
            this.clean.clean();
        }

        public String toString() {
            return "LeakDetectingResponse{delegate=" + this.delegate + ", leakDetector=" + this.leakDetector + "}";
        }
    }

    private static final class LeakDetectingInputStream
    extends FilterInputStream {
        private final LeakDetectingResponse leakDetectingResponse;

        LeakDetectingInputStream(InputStream delegate, LeakDetectingResponse leakDetectingResponse) {
            super(delegate);
            this.leakDetectingResponse = leakDetectingResponse;
        }

        @Override
        public void close() throws IOException {
            try {
                this.leakDetectingResponse.disarm();
            }
            finally {
                super.close();
            }
        }

        public String toString() {
            return "LeakDetectingInputStream{leakDetectingResponse=" + this.leakDetectingResponse + ", in=" + this.in + "}";
        }
    }

    private static final class LeakDetector
    implements Runnable {
        private final Endpoint endpoint;
        private final Response response;
        private final String clientName;
        private final DialogueClientMetrics metrics;
        @Nullable
        private final String creationTraceId;
        @Nullable
        private final Throwable creationTrace;
        private boolean armed = true;

        LeakDetector(Response response, Endpoint endpoint, String clientName, DialogueClientMetrics metrics) {
            this.response = response;
            this.endpoint = endpoint;
            this.clientName = clientName;
            this.metrics = metrics;
            this.creationTraceId = Tracer.hasTraceId() ? Tracer.getTraceId() : null;
            this.creationTrace = log.isTraceEnabled() ? new SafeRuntimeException("created here", new Arg[0]) : null;
        }

        void disarm() {
            this.armed = false;
        }

        @Override
        public void run() {
            if (this.armed) {
                this.metrics.responseLeak().clientName(this.clientName).serviceName(this.endpoint.serviceName()).endpoint(this.endpoint.endpointName()).build().mark();
                if (this.creationTrace == null) {
                    log.warn("Detected a leaked response from service {} endpoint {} on channel {} with traceId {}. Enable trace logging to record stack traces.", SafeArg.of("service", this.endpoint.serviceName()), SafeArg.of("endpoint", this.endpoint.endpointName()), SafeArg.of("client", this.clientName), SafeArg.of("creationTraceId", this.creationTraceId));
                } else {
                    log.warn("Detected a leaked response from service {} endpoint {} on channel {} with traceId {}", SafeArg.of("service", this.endpoint.serviceName()), SafeArg.of("endpoint", this.endpoint.endpointName()), SafeArg.of("client", this.clientName), SafeArg.of("creationTraceId", this.creationTraceId), this.creationTrace);
                }
                this.response.close();
            }
        }

        public String toString() {
            return "LeakDetector{endpoint=" + this.endpoint + ", response=" + this.response + ", armed=" + this.armed + "}";
        }
    }
}

