/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.dialogue.hc5;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.exceptions.SafeExceptions;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import shadow.palantir.driver.com.google.errorprone.annotations.CompileTimeConstant;

final class SafeSocketTimeoutException
extends SocketTimeoutException
implements SafeLoggable {
    private final String message;
    private final List<Arg<?>> arguments;

    SafeSocketTimeoutException(@CompileTimeConstant String message, IOException cause) {
        super(message);
        this.initCause(cause);
        this.message = message;
        this.arguments = Collections.emptyList();
    }

    SafeSocketTimeoutException(@CompileTimeConstant String message, IOException cause, Arg<?> ... args) {
        super(SafeExceptions.renderMessage(message, args));
        this.initCause(cause);
        this.message = message;
        this.arguments = Collections.unmodifiableList(Arrays.asList(args));
    }

    @Override
    public String getLogMessage() {
        return this.message;
    }

    @Override
    public List<Arg<?>> getArgs() {
        return this.arguments;
    }
}

